/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.filters;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.panels.filters.AbstractProjectFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.gui.GBC;

public class ProjectSpaceFilterPanel
extends AbstractProjectFilter {
    private JTextField initialAllocatedSpaceField;
    private JTextField finalAllocatedSpaceField;
    private JTextField initialOccupiedSpaceField;
    private JTextField finalOccupiedSpaceField;
    private JPanel allocatedFromSpacePanel;
    private JPanel allocatedUntilSpacePanel;
    private JLabel allocatedSpaceLabel;
    private JPanel occupiedFromSpacePanel;
    private JPanel occupiedUntilSpacePanel;
    private JLabel occupiedSpaceLabel;
    private JLabel initialAllocatedLabel;
    private JLabel finalAllocatedLabel;
    private JLabel initialOccupiedLabel;
    private JLabel finalOccupiedLabel;

    public ProjectSpaceFilterPanel(ProjectsManager projectsManager) {
        super(projectsManager);
    }

    @Override
    protected void initComponents() {
        this.initialAllocatedSpaceField = new JTextField();
        this.finalAllocatedSpaceField = new JTextField();
        this.initialOccupiedSpaceField = new JTextField();
        this.finalOccupiedSpaceField = new JTextField();
        this.allocatedSpaceLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.allocated.space.title"));
        this.occupiedSpaceLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.occupied.space.title"));
        this.initialAllocatedLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.initial.allocated.space.label"));
        this.finalAllocatedLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.final.allocated.space.label"));
        this.initialOccupiedLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.initial.occupied.space.label"));
        this.finalOccupiedLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.final.occupied.space.label"));
        this.initialAllocatedLabel.setForeground(Color.GRAY);
        this.finalAllocatedLabel.setForeground(Color.GRAY);
        this.initialOccupiedLabel.setForeground(Color.GRAY);
        this.finalOccupiedLabel.setForeground(Color.GRAY);
    }

    @Override
    protected void buildPanel() {
        this.setLayout(new GridBagLayout());
        JLabel gbytesLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.gbytes.label"));
        gbytesLabel.setForeground(Color.GRAY);
        JLabel mbytesLabel = new JLabel(this.getString("ProjectSpaceFilterPanel.mbytes.label"));
        mbytesLabel.setForeground(Color.GRAY);
        this.allocatedFromSpacePanel = new JPanel(new GridBagLayout());
        this.allocatedFromSpacePanel.add((Component)this.initialAllocatedLabel, new GBC(0, 0));
        this.allocatedFromSpacePanel.add((Component)this.initialAllocatedSpaceField, new GBC(1, 0).horizontal().insets(0, 10, 0, 0));
        this.allocatedFromSpacePanel.add((Component)gbytesLabel, new GBC(2, 0).insets(0, 0, 0, 10));
        this.allocatedUntilSpacePanel = new JPanel(new GridBagLayout());
        this.allocatedUntilSpacePanel.add((Component)this.finalAllocatedLabel, new GBC(1, 0));
        this.allocatedUntilSpacePanel.add((Component)this.finalAllocatedSpaceField, new GBC(2, 0).horizontal().insets(0, 10, 0, 0));
        this.allocatedUntilSpacePanel.add((Component)gbytesLabel, new GBC(3, 0));
        this.add((Component)this.allocatedFromSpacePanel, new GBC(0, 0).horizontal());
        this.add((Component)this.allocatedUntilSpacePanel, new GBC(0, 0).horizontal());
        this.occupiedFromSpacePanel = new JPanel(new GridBagLayout());
        this.occupiedFromSpacePanel.add((Component)this.initialOccupiedLabel, new GBC(0, 0));
        this.occupiedFromSpacePanel.add((Component)this.initialOccupiedSpaceField, new GBC(1, 0).horizontal().insets(0, 10, 0, 0));
        this.occupiedFromSpacePanel.add((Component)mbytesLabel, new GBC(2, 0).insets(0, 0, 0, 10));
        this.occupiedUntilSpacePanel = new JPanel(new GridBagLayout());
        this.occupiedUntilSpacePanel.add((Component)this.finalOccupiedLabel, new GBC(0, 0));
        this.occupiedUntilSpacePanel.add((Component)this.finalOccupiedSpaceField, new GBC(1, 0).horizontal().insets(0, 10, 0, 0));
        this.occupiedUntilSpacePanel.add((Component)mbytesLabel, new GBC(2, 0));
        this.add((Component)this.occupiedFromSpacePanel, new GBC(1, 0).horizontal());
        this.add((Component)this.occupiedUntilSpacePanel, new GBC(2, 0).horizontal());
    }

    private Number fieldToValue(JTextField field, Number defaultValue) {
        Number result;
        block5: {
            String text = field.getText();
            if (text.trim().isEmpty()) {
                return defaultValue;
            }
            result = defaultValue;
            try {
                if (defaultValue instanceof Long) {
                    result = Long.valueOf(text);
                    break block5;
                }
                if (defaultValue instanceof Double) {
                    result = Double.valueOf(text);
                    break block5;
                }
                throw new RuntimeException(this.getString("ProjectSpaceFilterPanel.invalid.default.value.message") + defaultValue);
            }
            catch (NumberFormatException e) {
                ProjectsManager projectsManager = this.getProjectsManager();
                projectsManager.showError("<<" + this.getString("ProjectSpaceFilterPanel.invalid.value.message") + text + ">>");
            }
        }
        return result;
    }

    private SpaceData fillSpaceData() {
        SpaceData spaceData = new SpaceData();
        spaceData.allocationMin = this.fieldToValue(this.initialAllocatedSpaceField, 0L).longValue();
        spaceData.allocationMax = this.fieldToValue(this.finalAllocatedSpaceField, Long.MAX_VALUE).longValue();
        spaceData.occupationMin = this.fieldToValue(this.initialOccupiedSpaceField, -1.0).doubleValue();
        spaceData.occupationMax = this.fieldToValue(this.finalOccupiedSpaceField, Double.MAX_VALUE).doubleValue();
        return spaceData;
    }

    @Override
    public void runSpecificFilter(List<ProjectsManagerData> allProjects, List<ProjectsManagerData> filteredProjects) {
        SpaceData spaceData = this.fillSpaceData();
        if (!spaceData.passesBasicTests()) {
            return;
        }
        for (ProjectsManagerData pmd : allProjects) {
            if (!this.projectMatchesFilter(spaceData, pmd)) continue;
            filteredProjects.add(pmd);
        }
    }

    @Override
    public boolean projectMatchesFilter(ProjectsManagerData prj) {
        return this.projectMatchesFilter(this.fillSpaceData(), prj);
    }

    private boolean projectMatchesFilter(SpaceData spaceData, ProjectsManagerData prj) {
        if (!spaceData.passesBasicTests()) {
            return false;
        }
        long allocatedSpace = prj.getAllocatedSpace();
        double occupiedSpace = prj.getOccupiedSpace();
        return spaceData.contains(allocatedSpace, occupiedSpace);
    }

    @Override
    public void addListener(KeyListener kl) {
        this.initialAllocatedSpaceField.addKeyListener(kl);
        this.finalAllocatedSpaceField.addKeyListener(kl);
        this.initialOccupiedSpaceField.addKeyListener(kl);
        this.finalOccupiedSpaceField.addKeyListener(kl);
    }

    @Override
    public void emptyFilterData() {
        this.initialAllocatedSpaceField.setText("");
        this.finalAllocatedSpaceField.setText("");
        this.initialOccupiedSpaceField.setText("");
        this.finalOccupiedSpaceField.setText("");
    }

    public JLabel getAllocatedSpaceLabel() {
        return this.allocatedSpaceLabel;
    }

    public JLabel getOccupiedSpaceLabel() {
        return this.occupiedSpaceLabel;
    }

    public JPanel getOccupiedFromSpacePanel() {
        return this.occupiedFromSpacePanel;
    }

    public JPanel getOccupiedUntilSpacePanel() {
        return this.occupiedUntilSpacePanel;
    }

    public JPanel getAllocatedFromSpacePanel() {
        return this.allocatedFromSpacePanel;
    }

    public JPanel getAllocatedUntilSpacePanel() {
        return this.allocatedUntilSpacePanel;
    }

    private static class SpaceData {
        long allocationMin;
        long allocationMax;
        double occupationMin;
        double occupationMax;

        private SpaceData() {
        }

        public boolean passesBasicTests() {
            return this.allocationMin >= 0L && this.allocationMin < this.allocationMax && this.occupationMin < this.occupationMax;
        }

        public boolean contains(long allocation, double occupation) {
            return allocation >= this.allocationMin && allocation <= this.allocationMax && occupation >= this.occupationMin && occupation <= this.occupationMax;
        }
    }
}

