/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.ias.IncludePasswordDialog;
import csbase.client.ias.UserGroupName;
import csbase.client.ias.UserInfoCallBackInterface;
import csbase.client.ias.UserInfoDialog;
import csbase.client.ias.UserPermissionDefinitionDialog;
import csbase.client.ias.UserRoleDefinitionDialog;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.srvproxies.UserGroupProxy;
import csbase.client.remote.srvproxies.UserProxy;
import csbase.client.util.ClientUtilities;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.logic.UserInfo;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.configurationmanager.ConfigurationManagerException;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GUIUtils;

public class IncludeUserInfoDialog
extends UserInfoDialog {
    private JComboBox userGroupComboBox;
    private JCheckBox forceLocalLoginCheckBox;
    private JButton includeUserButton;
    private JButton roleButton;
    private JButton permissionButton;
    private JLabel groupLabel;

    public IncludeUserInfoDialog(Window ownerWindow) {
        super(ownerWindow, ClientUtilities.addSystemNameToTitle(LNG.get((String)"ias.user.inclusion_title")));
    }

    @Override
    protected void updateUserInfo() {
        super.updateUserInfo();
        UserGroupName userGroupName = (UserGroupName)this.userGroupComboBox.getSelectedItem();
        UserGroup userGroup = userGroupName.getUserGroup();
        this.userInfo.setAttribute("unId", userGroup.getId());
        if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
            Boolean forceLocalLogin = new Boolean(this.forceLocalLoginCheckBox.isSelected());
            this.userInfo.setAttribute("forceLocalLogin", (Object)forceLocalLogin);
        }
    }

    @Override
    protected JPanel makeLowerPanel() {
        JPanel buttonPanel = super.makeLowerPanel();
        this.includeUserButton = this.makeIncludeUserButton();
        this.includeUserButton.setEnabled(false);
        buttonPanel.add((Component)this.includeUserButton, 0);
        return buttonPanel;
    }

    private JButton makeIncludeUserButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_INCLUDE"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                IncludeUserInfoDialog.this.createUser();
            }
        });
        return button;
    }

    protected boolean createUser() {
        this.updateUserInfo();
        if (ClientRemoteMonitor.getInstance().canChangePasswords() || this.forceLocalLoginCheckBox != null && this.forceLocalLoginCheckBox.isSelected()) {
            IncludePasswordDialog dialog = new IncludePasswordDialog(this.userInfoDialog);
            String password = dialog.getNewPassword();
            if (password == null) {
                return false;
            }
            this.userInfo.setAttribute("password", (Object)password);
        } else {
            this.userInfo.setAttribute("password", (Object)this.userInfo.getLogin());
        }
        Date currentDate = Calendar.getInstance().getTime();
        this.userInfo.setAttribute("creationDate", (Object)currentDate);
        User user = UserProxy.createUser(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_USER_CREATION"), this.userInfo);
        if (user == null) {
            return false;
        }
        JOptionPane.showMessageDialog(this.userInfoDialog, MessageFormat.format(LNG.get((String)"IAS_USER_INCLUDED_WITH_SUCCESS"), user.getLogin()), this.dialogTitle, 1);
        this.clearFields();
        return true;
    }

    protected void clearFields() {
        this.login.setText("");
        this.name.setText("");
        this.emailsModel.clear();
        this.addEmailTf.setText("");
        this.login.requestFocus();
        this.clearRoleSelection();
        this.clearPermissionSelection();
        this.includeUserButton.setEnabled(false);
    }

    private void clearPermissionSelection() {
        this.userInfo.setAttribute("permissionIds", (Object)new Object[0]);
    }

    private void clearRoleSelection() {
        this.userInfo.setAttribute("roleIds", (Object)new Object[0]);
    }

    @Override
    protected void makeDialog() {
        try {
            super.makeDialog();
        }
        catch (IllegalStateException ex) {
            StandardErrorDialogs.showErrorDialog(this.ownerWindow, this.dialogTitle, ex.getMessage());
        }
    }

    private JComboBox makeUserGroupComboBox() {
        JComboBox<UserGroupName> combo = new JComboBox<UserGroupName>();
        Vector<UserGroup> userGroups = UserGroupProxy.getAllUserGroups(this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_WAITING_ALL_USERGROUPS"));
        if (userGroups == null) {
            throw new IllegalStateException(LNG.get((String)"ias.usergroup.retrieval_error"));
        }
        Collections.sort(userGroups, UserGroup.getNameComparator());
        int userGroupSize = userGroups.size();
        for (int i = 0; i < userGroupSize; ++i) {
            combo.addItem(new UserGroupName(userGroups.get(i)));
        }
        if (userGroupSize > 0) {
            combo.setSelectedIndex(0);
        }
        return combo;
    }

    private JCheckBox makeForceLocalLoginCheckBox() {
        JCheckBox checkbox = new JCheckBox(LNG.get((String)"IAS_USER_FORCE_LOCAL_LOGIN"));
        return checkbox;
    }

    @Override
    protected List<JComponent[]> createDataComponents() {
        List<JComponent[]> components = super.createDataComponents();
        JLabel userGroupLabel = new JLabel(LNG.get((String)"IAS_USER_USERGROUP"));
        JLabel unLabel = new JLabel("");
        this.userGroupComboBox = this.makeUserGroupComboBox();
        this.groupLabel = this.makeGroupLabel();
        components.add(new JComponent[]{userGroupLabel, this.userGroupComboBox});
        if (!ClientRemoteMonitor.getInstance().isLocalLogin()) {
            JLabel forceLoginLabel = new JLabel(LNG.get((String)"IAS_USER_AUTHENTICATION"));
            this.forceLocalLoginCheckBox = this.makeForceLocalLoginCheckBox();
            components.add(new JComponent[]{forceLoginLabel, this.forceLocalLoginCheckBox});
        }
        components.add(new JComponent[]{unLabel, this.groupLabel});
        return components;
    }

    private JLabel makeGroupLabel() {
        JLabel label = new JLabel();
        label.setVisible(false);
        return label;
    }

    @Override
    protected void addDataComponentsListeners() {
        super.addDataComponentsListeners();
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IncludeUserInfoDialog.this.fireOnDataChanged();
            }
        };
        if (this.userGroupComboBox != null) {
            this.userGroupComboBox.addItemListener(itemListener);
        }
        if (this.forceLocalLoginCheckBox != null) {
            this.forceLocalLoginCheckBox.addItemListener(itemListener);
        }
    }

    @Override
    protected boolean confirmClose() {
        int selected;
        Object[] options = new Object[]{LNG.get((String)"IAS_INCLUDE"), LNG.get((String)"IAS_NOT_INCLUDE"), LNG.get((String)"IAS_CANCEL")};
        if (options[selected = JOptionPane.showOptionDialog(this.userInfoDialog, LNG.get((String)"IAS_USER_ADD_CONFIRMATION"), LNG.get((String)"IAS_USER_ADD_NOT_DONE_TITLE"), -1, 1, null, options, options[0])].equals(LNG.get((String)"IAS_INCLUDE"))) {
            if (this.requiredFieldsAreFilled()) {
                return this.createUser();
            }
            StandardErrorDialogs.showErrorDialog((Window)this.userInfoDialog, this.dialogTitle, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
            return false;
        }
        return options[selected].equals(LNG.get((String)"IAS_NOT_INCLUDE"));
    }

    @Override
    protected JPanel makeMiddlePanel() {
        JPanel panel = new JPanel();
        this.roleButton = this.makeRoleButton();
        panel.add(this.roleButton);
        this.permissionButton = this.makePermissionButton();
        panel.add(this.permissionButton);
        JComponent[] buttons = new JComponent[]{this.roleButton, this.permissionButton};
        GUIUtils.matchPreferredSizes((JComponent[])buttons);
        return panel;
    }

    private JButton makePermissionButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_PERMISSIONS_BUTTON"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new UserPermissionDefinitionDialog(IncludeUserInfoDialog.this.userInfoDialog, IncludeUserInfoDialog.this.userInfo, null, true).showDialog();
                IncludeUserInfoDialog.this.enableIncludeUserButtonIfAllowed();
            }
        });
        return button;
    }

    private JButton makeRoleButton() {
        JButton button = new JButton(LNG.get((String)"IAS_USER_ROLES_BUTTON"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new UserRoleDefinitionDialog(IncludeUserInfoDialog.this.userInfoDialog, IncludeUserInfoDialog.this.userInfo, null, true).showDialog();
                IncludeUserInfoDialog.this.enableIncludeUserButtonIfAllowed();
            }
        });
        return button;
    }

    protected void sendUserInfoCallBackObject(final UserInfoCallBackInterface callBack) {
        if (callBack == null) {
            return;
        }
        this.getLogin().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && IncludeUserInfoDialog.this.getLogin().getText().length() > 0) {
                    IncludeUserInfoDialog.this.addUserInfo(callBack.obtainUserInfo(IncludeUserInfoDialog.this.login.getText()));
                }
            }
        });
        this.getLogin().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (IncludeUserInfoDialog.this.getLogin().getText().length() > 0) {
                    IncludeUserInfoDialog.this.addUserInfo(callBack.obtainUserInfo(IncludeUserInfoDialog.this.login.getText()));
                }
            }
        });
    }

    protected void addUserInfo(UserInfo info) {
        if (info == null) {
            return;
        }
        if (info.getAttributes().get("name") != null) {
            this.name.setText(info.getAttributes().get("name").toString());
        }
        this.emailsModel.removeAllElements();
        if (info.getAttributes().get("emails") != null) {
            for (String email : (String[])info.getAttributes().get("emails")) {
                this.emailsModel.addElement(email.toString());
            }
        }
        this.userGroupComboBox.setSelectedIndex(-1);
        if (info.getAttributes().get("unId") != null) {
            for (int i = 0; i < this.userGroupComboBox.getModel().getSize(); ++i) {
                UserGroupName groupName = (UserGroupName)this.userGroupComboBox.getModel().getElementAt(i);
                if (!groupName.getUserGroup().getUserGroupInfo().name.equals(info.getAttribute("unId"))) continue;
                this.userGroupComboBox.setSelectedIndex(i);
                break;
            }
        }
        if (this.userGroupComboBox.getSelectedIndex() != -1) {
            return;
        }
        String hasLabel = null;
        try {
            Configuration conf = ConfigurationManager.getInstance().getConfiguration(IncludeUserInfoDialog.class);
            hasLabel = conf.getOptionalProperty("show.label");
        }
        catch (ConfigurationManagerException e) {
            e.printStackTrace();
        }
        if (hasLabel != null && hasLabel.equals("true")) {
            this.groupLabel.setText("UN: " + info.getAttribute("unId"));
            this.groupLabel.setVisible(true);
            super.getUserInfoDialog().pack();
        } else {
            this.groupLabel.setVisible(false);
        }
    }

    @Override
    protected boolean unsavedDataInput() {
        return this.requiredFieldsAreFilled();
    }

    private void enableIncludeUserButtonIfAllowed() {
        this.includeUserButton.setEnabled(this.requiredFieldsAreFilled());
    }

    @Override
    protected void fireOnDataChanged() {
        this.enableIncludeUserButtonIfAllowed();
    }

    @Override
    protected boolean requiredFieldsAreFilled() {
        return super.requiredFieldsAreFilled() && this.userGroupComboBox.getSelectedIndex() != -1;
    }
}

