/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DateTableCellRenderer
extends DefaultTableCellRenderer {
    private static final String DEFAULT_DATE_PATTERN = "dd/MM/yyyy - HH:mm:ss";
    private String emptyValue = "";
    private DateFormat formatter;

    public DateTableCellRenderer() {
        this.formatter = new SimpleDateFormat(DEFAULT_DATE_PATTERN);
    }

    public DateTableCellRenderer(DateFormat formatter) {
        this.formatter = formatter;
    }

    public void setDefaultEmptyValue(String emptyValue) {
        this.emptyValue = emptyValue;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value == null) {
            ((DefaultTableCellRenderer)comp).setText(this.emptyValue);
        } else if (value instanceof Date) {
            Date date = (Date)value;
            String strDate = this.formatter.format(date);
            ((DefaultTableCellRenderer)comp).setText(strDate);
            this.setToolTipText(strDate);
        }
        return comp;
    }
}

