/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.tasks;

import csbase.client.algorithms.validation.ViewValidationResult;
import csbase.client.algorithms.validation.ViewValidator;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;

public class ViewValidationTask
extends RemoteTask<ViewValidationResult> {
    private final ViewValidator viewValidator;
    private final ValidationMode mode;
    private final boolean complain;

    public ViewValidationTask(ViewValidator view, ValidationMode mode, boolean complain) {
        this.viewValidator = view;
        this.mode = mode;
        this.complain = complain;
    }

    protected void performTask() throws Exception {
        ViewValidationResult validation = this.viewValidator.validate(this.mode);
        this.setResult((Object)validation);
    }

    protected void afterTaskUI() {
        ViewValidationResult result = (ViewValidationResult)((Object)this.getResult());
        if (result != null && this.complain) {
            this.viewValidator.highlightValidationResult(result);
        }
    }

    public static final ViewValidationResult runTask(Window window, ViewValidator view, ValidationMode mode, boolean complain) {
        String msg;
        ViewValidationTask task = new ViewValidationTask(view, mode, complain);
        String className = ViewValidationTask.class.getSimpleName();
        String title = LNG.get((String)(className + ".title"));
        if (task.execute(window, title, msg = LNG.get((String)(className + ".msg")))) {
            return (ViewValidationResult)((Object)task.getResult());
        }
        if (task.wasCancelled()) {
            LocalizedMessage message = new LocalizedMessage(ViewValidationTask.class, "cancelled");
            return new ViewValidationResult((Validation)new ValidationError(message), view);
        }
        Exception error = task.getError();
        error.printStackTrace();
        LocalizedMessage message = new LocalizedMessage(ViewValidationTask.class, "error", new Object[]{error.getMessage()});
        return new ViewValidationResult((Validation)new ValidationError(message), view);
    }
}

