/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications;

import csbase.client.ClientKeyStrokeUtil;
import csbase.client.applications.Application;
import csbase.client.applications.ApplicationAction;
import csbase.client.applications.ApplicationFrame;
import csbase.client.util.StandardErrorDialogs;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class AbstractSimpleApplicationAction<T extends Application>
extends ApplicationAction<T> {
    protected static final String TAG_NAME = "name";
    protected static final String TAG_MNEMONIC = "mnemonic";
    protected static final String TAG_TOOLTIP = "tooltip";
    protected static final String TAG_ACCELERATOR = "accelerator";

    protected AbstractSimpleApplicationAction(T application, ImageIcon icon) {
        this(application);
        this.putValue("SmallIcon", icon);
    }

    protected AbstractSimpleApplicationAction(T application) {
        super(application);
        KeyStroke keyStroke;
        String tooltip;
        Integer mnemonic;
        String name = this.getName();
        if (name != null) {
            this.putValue("Name", name);
        }
        if ((mnemonic = this.getMnemonic()) != null) {
            this.putValue("MnemonicKey", mnemonic);
        }
        if ((tooltip = this.getToolTip()) != null) {
            this.putValue("ShortDescription", tooltip);
        }
        if ((keyStroke = this.getAccelerator()) != null) {
            this.putValue("AcceleratorKey", keyStroke);
        }
        this.putDefaultIcon(application);
    }

    private void putDefaultIcon(T application) {
        ImageIcon defaultIcon = this.getDefaultIcon();
        if (defaultIcon != null) {
            this.putValue("SmallIcon", defaultIcon);
            return;
        }
        ImageIcon internalIcon = this.loadInternalIcon();
        if (internalIcon != null) {
            this.putValue("SmallIcon", internalIcon);
        }
    }

    protected ImageIcon getDefaultIcon() {
        return null;
    }

    private final ImageIcon loadInternalIcon() {
        Object application = this.getApplication();
        String sep = "/";
        Class<?> appClass = application.getClass();
        Class<?> actionClass = this.getClass();
        String actionClassName = actionClass.getSimpleName();
        String path = "actions/" + actionClassName + ".16.gif";
        String resPath = "resources/images/" + path;
        URL url = appClass.getResource(resPath);
        if (url == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(url);
        return imageIcon;
    }

    @Override
    public final void actionPerformed(ActionEvent ae) {
        try {
            this.handleActionPerformed(ae);
        }
        catch (Exception e) {
            Object application = this.getApplication();
            ApplicationFrame frame = ((Application)application).getApplicationFrame();
            String title = frame.getTitle();
            StandardErrorDialogs.showErrorDialog((Window)frame, title, (Throwable)e);
        }
    }

    protected abstract void handleActionPerformed(ActionEvent var1) throws Exception;

    protected final String getClassString(String key_sufix, Object ... args) {
        String className = this.getClass().getSimpleName();
        String formattedKey = String.format("%s.%s", className, key_sufix);
        Object app = this.getApplication();
        if (((Application)app).hasString(formattedKey)) {
            return ((Application)app).getString(formattedKey, args);
        }
        return null;
    }

    protected final String getString(String key_sufix, Object ... args) {
        Object app = this.getApplication();
        if (((Application)app).hasString(key_sufix)) {
            return ((Application)app).getString(key_sufix, args);
        }
        return null;
    }

    private final String getName() {
        String name = this.getClassString(TAG_NAME, new Object[0]);
        if (name == null) {
            String className = this.getClass().getSimpleName();
            return "<<" + className + "." + TAG_NAME + ">>";
        }
        return name;
    }

    private final String getToolTip() {
        return this.getClassString(TAG_TOOLTIP, new Object[0]);
    }

    private final Integer getMnemonic() {
        String mn = this.getClassString(TAG_MNEMONIC, new Object[0]);
        if (mn == null) {
            return null;
        }
        if (mn.trim().isEmpty()) {
            return null;
        }
        return mn.charAt(0);
    }

    private final KeyStroke getAccelerator() {
        String ac = this.getClassString(TAG_ACCELERATOR, new Object[0]);
        if (ac == null) {
            return null;
        }
        if (ac.trim().isEmpty()) {
            return null;
        }
        return this.getStrokeFromText(ac);
    }

    protected KeyStroke getStrokeFromText(String text) {
        KeyStroke keyStroke = ClientKeyStrokeUtil.getCtrlKeyStroke(text);
        return keyStroke;
    }
}

