/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.models;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.models.CategoryNodeInterface;
import csbase.logic.algorithms.Category;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import javax.swing.Icon;
import tecgraf.javautils.gui.tree.DefaultNode;

public final class CategoryTreeNode
extends DefaultNode
implements CategoryNodeInterface,
Comparable<CategoryTreeNode> {
    private Category node;

    public CategoryTreeNode(Category node) {
        super(node.getName());
        this.node = node;
        ArrayList<CategoryTreeNode> treeNodes = new ArrayList<CategoryTreeNode>();
        SortedSet nodes = node.getCategories();
        for (Category childNode : nodes) {
            treeNodes.add(new CategoryTreeNode(childNode));
        }
        Collections.sort(treeNodes);
        for (CategoryTreeNode treeNode : treeNodes) {
            this.addChild(treeNode);
        }
    }

    @Override
    public int compareTo(CategoryTreeNode node) {
        return this.getNode().compareTo(node.getNode());
    }

    @Override
    public Icon getIcon() {
        return ApplicationImages.ICON_FOLDER_16;
    }

    @Override
    public Category getNode() {
        return this.node;
    }

    @Override
    public int compare(Category node) {
        return this.getNode().compareTo(node);
    }

    @Override
    public SortedSet<Category> getSubNodes() {
        return this.getNode().getCategories();
    }

    @Override
    public String getFullName() {
        return this.getNode().getFullName();
    }

    @Override
    public String getId() {
        return this.getNode().getId();
    }

    @Override
    public String getName() {
        return this.getNode().getName();
    }

    @Override
    public boolean isRootNode() {
        return false;
    }
}

