/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.filetransferclient.panels.localpanel;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.project.ClientProjectFileProperties;
import csbase.logic.ClientProjectFile;
import java.awt.Color;
import java.awt.Component;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import tecgraf.javautils.core.lng.FormatUtils;

class LocalTableRenderer
implements TableCellRenderer {
    public static final DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = DEFAULT_RENDERER.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        JLabel label = (JLabel)renderer;
        label.setOpaque(true);
        label.setIcon(null);
        label.setHorizontalAlignment(2);
        label.setForeground(Color.black);
        if (column == 0) {
            ClientProjectFile file = (ClientProjectFile)value;
            label.setHorizontalAlignment(0);
            ImageIcon icon = ClientProjectFileProperties.getImageIcon(file);
            label.setIcon(icon);
            label.setText(null);
        } else if (column == 1) {
            String name = (String)value;
            label.setHorizontalAlignment(2);
            label.setText(name);
        } else if (column == 2) {
            label.setHorizontalAlignment(4);
            long sz = (Long)value;
            if (sz < 0L) {
                label.setText(null);
            } else {
                ApplicationManager mgr = ApplicationManager.getInstance();
                label.setText(FormatUtils.formatSize((long)sz, (int)2, (Locale)mgr.getLocale()));
            }
        }
        return label;
    }
}

