/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.models;

import csbase.client.applications.projectsmanager.models.ProjectSpaceAllocation;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import java.util.Set;

public class ProjectsManagerData {
    private final Object projectId;
    private final String projectName;
    private String projectDescription;
    private final Object ownerId;
    private String ownerName;
    private long allocatedSpace;
    private long requestedSpace;
    private double occupiedSpace;
    private long creationDate;
    private long modificationDate;
    private ProjectsManagerScope scope;
    private ProjectPermissions.SharingType sharingType;
    private ProjectSpaceAllocation projectSpaceAllocation;
    private String location;
    private Set<Object> usersRO;
    private Set<Object> usersRW;
    private String serverOwnerName;

    public String getServerOwnerName() {
        return this.serverOwnerName;
    }

    public void setServerOwnerName(String serverOwnerName) {
        this.serverOwnerName = serverOwnerName;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(long creationDate) {
        this.creationDate = creationDate;
    }

    public long getModificationDate() {
        return this.modificationDate;
    }

    public final String getLocationInServer() {
        return this.location;
    }

    public void setLocationInServer(String location) {
        this.location = location;
    }

    public void setModificationDate(long modificationDate) {
        this.modificationDate = modificationDate;
    }

    public Object getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public Object getOwnerId() {
        return this.ownerId;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public long getAllocatedSpace() {
        return this.allocatedSpace;
    }

    public void setAllocatedSpace(long allocatedSpace) {
        this.allocatedSpace = allocatedSpace;
    }

    public double getOccupiedSpace() {
        return this.occupiedSpace;
    }

    public void setOccupiedSpace(double occupiedSpace) {
        this.occupiedSpace = occupiedSpace;
    }

    public String getProjectDescription() {
        return this.projectDescription;
    }

    public void setProjectDescription(String projectDescription) {
        this.projectDescription = projectDescription;
    }

    public Set<Object> getUsersRO() {
        return this.usersRO;
    }

    public boolean setUsers(Set<Object> usersRO, Set<Object> usersRW) {
        boolean changed = false;
        if (usersRO != null) {
            this.usersRO = usersRO;
            changed = true;
        }
        if (usersRW != null) {
            this.usersRW = usersRW;
            changed = true;
        }
        return changed;
    }

    public Set<Object> getUsersRW() {
        return this.usersRW;
    }

    public boolean userIsOwner(Object uid) {
        return User.isAdmin((Object)uid) || this.ownerId.equals(uid);
    }

    public final void setScope(ProjectsManagerScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope == null!");
        }
        this.scope = scope;
    }

    public final ProjectsManagerScope getScope() {
        return this.scope;
    }

    public void clearData() {
        this.sharingType = ProjectPermissions.SharingType.PRIVATE;
        this.creationDate = 0L;
        this.modificationDate = 0L;
        this.occupiedSpace = -1.0;
        this.scope = ProjectsManagerScope.NOT_APPLICABLE;
    }

    public final ProjectSpaceAllocation getProjectSpaceAllocation() {
        return this.projectSpaceAllocation;
    }

    public final void setProjectSpaceAllocation(ProjectSpaceAllocation projectSpaceAllocation) {
        this.projectSpaceAllocation = projectSpaceAllocation;
    }

    public long getRequestedSpace() {
        return this.requestedSpace;
    }

    public void setRequestedSpace(long requestedSpace) {
        this.requestedSpace = requestedSpace;
    }

    public ProjectPermissions.SharingType getSharingType() {
        return this.sharingType;
    }

    public boolean setSharingType(ProjectPermissions.SharingType st) {
        if (this.sharingType == st) {
            return false;
        }
        this.sharingType = st;
        if (this.projectSpaceAllocation == ProjectSpaceAllocation.WAITING_ALLOCATION || this.projectSpaceAllocation == ProjectSpaceAllocation.WAITING_DEALLOCATION) {
            this.scope = ProjectsManagerScope.NOT_APPLICABLE;
            return true;
        }
        switch (st) {
            case PRIVATE: {
                this.scope = ProjectsManagerScope.PRIVATE;
                break;
            }
            case ALL_RO: 
            case ALL_RW: {
                this.scope = ProjectsManagerScope.PUBLIC;
                break;
            }
            case PARTIAL: {
                this.scope = ProjectsManagerScope.SHARED;
            }
        }
        return true;
    }

    public ProjectsManagerData(Object projectId, String projectName, Object ownerId) {
        this.projectId = projectId;
        this.projectName = projectName;
        this.ownerId = ownerId;
    }
}

