/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.projectsmanager.panels.renderers;

import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.models.ProjectsManagerScope;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ProjectListCellRenderer
implements ListCellRenderer {
    private final boolean displayOwner;

    public ProjectListCellRenderer(boolean displayOwner) {
        this.displayOwner = displayOwner;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return null;
        }
        ProjectsManagerData pmd = (ProjectsManagerData)value;
        StringBuilder content = new StringBuilder(pmd.getProjectName());
        if (this.displayOwner) {
            content.append(" (" + pmd.getOwnerId() + ")");
        }
        JLabel label = new JLabel(content.toString());
        label.setHorizontalAlignment(2);
        ProjectsManagerScope scope = pmd.getScope();
        if (scope != null) {
            label.setIcon(scope.getIcon());
        }
        return label;
    }
}

