/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.sgamonitor.columns;

import csbase.client.facilities.configurabletable.column.AbstractConfigurableColumn;
import csbase.client.facilities.configurabletable.stringprovider.IStringProvider;
import csbase.logic.SGAInfo;
import csbase.logic.SGASet;
import java.awt.Component;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class RequirementsColumn
extends AbstractConfigurableColumn<SGASet> {
    public RequirementsColumn(String id, Boolean visible, IStringProvider stringProvider, Integer align) {
        super(id, visible, stringProvider, align);
    }

    public Class<?> getColumnClass() {
        return Set.class;
    }

    public String getColumnName() {
        return this.getString(this.getId());
    }

    public Object getValue(SGASet obj) {
        SGAInfo node = obj.getAllInfo()[0];
        return node.getRequirements();
    }

    @Override
    public TableCellRenderer createTableCellRenderer() {
        return new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                Set requirements = (Set)Set.class.cast(value);
                if (requirements.size() == 0) {
                    this.setToolTipText(null);
                    this.setText(AbstractConfigurableColumn.NO_VALUE);
                } else {
                    String ttTemplate = RequirementsColumn.this.getString("tooltip.requirements.template");
                    String ttEntry = RequirementsColumn.this.getString("tooltip.requirements.entry");
                    StringBuilder tooltipEntries = new StringBuilder();
                    for (Object aRequirement : requirements) {
                        tooltipEntries.append(String.format(ttEntry, aRequirement));
                    }
                    this.setToolTipText(String.format(ttTemplate, tooltipEntries));
                    StringBuilder text = new StringBuilder();
                    for (Object aRequirement : requirements) {
                        text.append(aRequirement.toString()).append(",");
                    }
                    this.setText(text.length() > 0 ? text.substring(0, text.length() - 1) : "");
                }
                return this;
            }
        };
    }
}

