/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.CommandListener;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.logic.CommandNotification;
import csbase.logic.CommonClientProject;
import csbase.logic.Notification;
import csbase.logic.NotificationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public class CommandNotificationHandler
implements NotificationHandler {
    private Executor executor;
    private final List<CommandListener> listeners = Collections.synchronizedList(new ArrayList());
    private static CommandNotificationHandler instance = new CommandNotificationHandler();
    private boolean updateProjectTree;
    private boolean runningTask;

    private CommandNotificationHandler() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    private boolean isInterested(Notification data) {
        return data instanceof CommandNotification;
    }

    public static CommandNotificationHandler getInstance() {
        return instance;
    }

    private synchronized boolean hasToUpdate() {
        if (this.updateProjectTree) {
            this.updateProjectTree = false;
            return true;
        }
        this.runningTask = false;
        return false;
    }

    private synchronized boolean createNewTask() {
        this.updateProjectTree = true;
        if (!this.runningTask) {
            this.runningTask = true;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gotNotification(Notification data) {
        if (!this.isInterested(data)) {
            return;
        }
        final CommandNotification notification = (CommandNotification)data;
        this.updateProjectTree(notification);
        ArrayList<CommandListener> toRemove = new ArrayList<CommandListener>();
        List<CommandListener> list = this.listeners;
        synchronized (list) {
            for (final CommandListener listener : this.listeners) {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.notifyCommand(notification);
                    }
                });
                if (!listener.shouldRemove()) continue;
                toRemove.add(listener);
            }
            for (final CommandListener listener : toRemove) {
                this.listeners.remove(listener);
            }
        }
    }

    private void updateProjectTree(CommandNotification notification) {
        final DesktopFrame desktop = DesktopFrame.getInstance();
        final CommonClientProject prj = desktop.getProject();
        if (prj != null && prj.getId().equals(notification.getProjectId())) {
            if (!desktop.mustUpdateProjectTree()) {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        desktop.getTree().setOutOfDate();
                    }
                });
                return;
            }
            if (this.createNewTask()) {
                while (this.hasToUpdate()) {
                    RemoteTask<Void> task = new RemoteTask<Void>(){

                        protected void performTask() throws Exception {
                            prj.refreshTree();
                        }
                    };
                    String prjName = prj.getName();
                    task.execute(DesktopComponentFrame.getFocusedWindow(), String.format(LNG.get((String)"CommandNotificationHandler.title.refresh.tree"), prjName), String.format(LNG.get((String)"CommandNotificationHandler.msg.refresh.tree"), prjName));
                }
            }
        }
    }

    public void addListener(CommandListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CommandListener listener) {
        this.listeners.remove(listener);
    }
}

