/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.remote.srvproxies.DiskUsageProxy;
import csbase.logic.CommonClientProject;
import csbase.logic.User;
import csbase.logic.diskusageservice.DiskOccupation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;

public class ProjectInfoDialog
extends DesktopComponentDialog {
    private final JTextField nameText = new JTextField(15);
    private final JTextArea descriptionText = new JTextArea(4, 15);
    private final JTextField userText = new JTextField(15);
    private final JTextField userNameText = new JTextField(20);
    private final JTextField serverOwnerText = new JTextField(15);
    private final JTextField usageText = new JTextField(15);
    private final JTextField freeText = new JTextField(15);

    private final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        return LNG.get((String)(className + "." + tag));
    }

    protected JPanel buildMainPanel() {
        JLabel nameLabel = new JLabel(this.getString("name.label"));
        JLabel descriptionLabel = new JLabel(this.getString("description.label"));
        JLabel usageLabel = new JLabel(this.getString("usage.label"));
        JLabel freeLabel = new JLabel(this.getString("free.label"));
        JLabel userLabel = new JLabel(this.getString("user.label"));
        JLabel userNameLabel = new JLabel(this.getString("user.name.label"));
        JLabel serverOwnerLabel = new JLabel(this.getString("server.owner.label"));
        this.userText.setEditable(false);
        this.nameText.setEditable(false);
        this.descriptionText.setEditable(false);
        this.descriptionText.setBackground(this.getBackground());
        this.usageText.setEditable(false);
        this.freeText.setEditable(false);
        this.userNameText.setEditable(false);
        this.serverOwnerText.setEditable(false);
        this.usageText.setHorizontalAlignment(4);
        this.freeText.setHorizontalAlignment(4);
        JScrollPane descriptionPane = new JScrollPane();
        descriptionPane.setVerticalScrollBarPolicy(22);
        descriptionPane.getViewport().add(this.descriptionText);
        JComponent[][] cmps = new JComponent[][]{{nameLabel, this.nameText}, {descriptionLabel, descriptionPane}, {userLabel, this.userText}, {userNameLabel, this.userNameText}, {serverOwnerLabel, this.serverOwnerText}, {new JLabel(" ")}, {usageLabel, this.usageText}, {freeLabel, this.freeText}};
        JPanel panel = this.mountBasicGridPanel(cmps);
        return panel;
    }

    private JPanel mountBasicGridPanel(JComponent[][] rows) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        if (rows == null) {
            return panel;
        }
        int T = 12;
        int TI = 6;
        int L = 11;
        int B = 12;
        int R = 11;
        int numRows = rows.length;
        for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
            JComponent[] row = rows[rowNumber];
            if (row == null) continue;
            int numCols = row.length;
            for (int colNumber = 0; colNumber < numCols; ++colNumber) {
                JComponent cell = row[colNumber];
                if (cell == null) continue;
                GBC gbc = new GBC(colNumber, rowNumber);
                gbc = gbc.gridheight(1).gridwidth(1);
                gbc = gbc.west().weights(1.0, 0.0);
                gbc = numRows == 1 ? gbc.insets(12, 11, 12, 11) : (rowNumber == 0 ? gbc.insets(12, 11, 0, 11) : (rowNumber == numRows - 1 ? gbc.insets(6, 11, 12, 11) : gbc.insets(6, 11, 0, 11)));
                gbc = colNumber == 1 ? (JScrollPane.class.isInstance(cell) ? gbc.both() : gbc.horizontal().weightx(100.0)) : gbc.none().northwest();
                panel.add((Component)cell, gbc);
            }
        }
        return panel;
    }

    protected JPanel buildButtonsPanel() {
        JPanel panel = new JPanel(new FlowLayout());
        JButton closeButton = new JButton(this.getString("close.button"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProjectInfoDialog.this.close();
            }
        });
        JButton refreshButton = new JButton(this.getString("refresh.button"));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ProjectInfoDialog.this.refresh();
            }
        });
        panel.add(refreshButton);
        panel.add(closeButton);
        GUIUtils.matchPreferredSizes((JComponent[])new JComponent[]{refreshButton, closeButton});
        return panel;
    }

    public final void refresh() {
        DesktopFrame desktopFrame = DesktopFrame.getInstance();
        CommonClientProject prj = desktopFrame.getProject();
        String projName = prj.getName();
        final Object ownerId = prj.getUserId();
        this.nameText.setText(projName);
        this.descriptionText.setText(prj.getDescription());
        this.descriptionText.setCaretPosition(0);
        this.userText.setText(ownerId.toString());
        RemoteTask<String> task = new RemoteTask<String>(){

            protected void performTask() throws Exception {
                this.setResult(User.getName((Object)ownerId));
            }
        };
        if (task.execute(desktopFrame.getDesktopFrame(), this.getTitle(), this.getString("get.user.name.msg"))) {
            this.userNameText.setText((String)task.getResult());
        }
        this.serverOwnerText.setText(prj.getOwnerServerName());
        DiskOccupation occ = DiskUsageProxy.getCurrentProjectOccupation();
        if (!occ.isValid()) {
            this.usageText.setText("?");
            this.freeText.setText("?");
            return;
        }
        double freeMb = occ.getFreeSpaceMb();
        double usedMb = occ.getUsedSpaceMb();
        String usageStr = this.getText(usedMb);
        String freeStr = this.getText(freeMb);
        this.usageText.setText(usageStr);
        this.freeText.setText(freeStr);
    }

    private String getText(double spaceMb) {
        double value = spaceMb;
        String unit = "mb";
        if (value > 1024.0) {
            value /= 1024.0;
            unit = "gb";
            if (value > 1024.0) {
                value /= 1024.0;
                unit = "tb";
            }
        }
        DecimalFormat formatter = new DecimalFormat("0.00");
        String text = formatter.format(value) + " " + unit;
        return text;
    }

    public ProjectInfoDialog(DesktopFrame desktopFrame) {
        super((Window)desktopFrame.getDesktopFrame());
        this.setTitle(this.getString("title"));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.buildMainPanel(), "Center");
        mainPanel.add((Component)this.buildButtonsPanel(), "South");
        Container container = this.getContentPane();
        container.add(mainPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ProjectInfoDialog.this.setSize(Double.valueOf(ProjectInfoDialog.this.getSize().getWidth()).intValue(), 300);
            }
        });
        this.setDefaultCloseOperation(2);
        this.pack();
    }
}

