/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.ias;

import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.ias.AbstractPermissionPanel;
import csbase.client.ias.AttributesPanel;
import csbase.client.ias.ChoicePermissionPanel;
import csbase.client.ias.UserPasswordPanel;
import csbase.client.remote.srvproxies.PermissionProxy;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.gui.CardPanel;
import csbase.logic.Permission;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.StandardDialogs;

public class PermissionInfoDialog
extends DesktopComponentDialog {
    private static final String SIMPLE_PERMISSION_CLASS = "csbase.logic.SimplePermission";
    private static final String ATTRIBUTES_PERMISSION_CLASS = "csbase.logic.AttributesPermission";
    private static final String USER_PASSWORD_PERMISSION_CLASS = "csbase.logic.UserPasswordPermission";
    private static final String CHOICE_PERMISSION_CLASS = "csbase.logic.ChoicePermission";
    private static final String DESCRIPTION_SUFFIX = ".desc";
    private Window owner;
    private String windowLabel;
    private Permission permission;
    private JTextField name;
    private JTextField description;
    JButton nextButton;
    JButton previousButton;
    private JComboBox permissionClass;
    private JTextArea permissionClassDesc;
    JButton includePermissionButton;
    private String selectedPermissionClass;
    private boolean isNew;
    private CardPanel permissionAtributePanels;
    JSeparator separator;

    public PermissionInfoDialog(Window owner) {
        this(owner, (Permission)null);
    }

    public PermissionInfoDialog(Window owner, Permission permission) {
        super(owner);
        this.owner = owner;
        if (permission == null) {
            this.isNew = true;
            this.windowLabel = LNG.get((String)"IAS_PERMISSION_INCLUSION_TITLE");
        } else {
            this.windowLabel = LNG.get((String)"IAS_PERMISSION_UPDATE_TITLE");
            this.isNew = false;
            this.permission = permission;
        }
        this.setTitle(this.windowLabel);
        this.display();
    }

    protected void display() {
        JPanel backPane = new JPanel(new GridBagLayout());
        backPane.add((Component)this.makeButtonPanel(), new GBC(0, 1).south().insets(0, 5, 5, 5));
        JPanel mainPane = new JPanel(new GridBagLayout());
        mainPane.add((Component)this.makeMainPanel(), new GBC(0, 0).insets(2, 0, 0, 0).both());
        mainPane.add((Component)this.makePermissionsButtonPanel(), new GBC(0, 1).south().insets(3));
        backPane.add((Component)mainPane, new GBC(0, 0).insets(5, 5, 0, 5).both());
        this.setContentPane(backPane);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.center(this.owner);
        this.setVisible(true);
    }

    protected Container makeMainPanel() {
        JPanel commonPanel = this.makeCommonPanel();
        this.permissionAtributePanels = new CardPanel(true, false);
        this.setResizable(true);
        this.permissionAtributePanels.add((Component)new UserPasswordPanel(this), USER_PASSWORD_PERMISSION_CLASS);
        this.permissionAtributePanels.add((Component)new AttributesPanel(this), ATTRIBUTES_PERMISSION_CLASS);
        this.permissionAtributePanels.add((Component)new ChoicePermissionPanel(this, this.windowLabel), CHOICE_PERMISSION_CLASS);
        this.permissionAtributePanels.add((Component)new JPanel(), SIMPLE_PERMISSION_CLASS);
        JSplitPane splitPane = new JSplitPane(0, true, commonPanel, this.permissionAtributePanels);
        splitPane.setResizeWeight(0.4);
        splitPane.setDividerLocation(0.5);
        this.initFields();
        return splitPane;
    }

    private JPanel makeCommonPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel nameL = new JLabel(LNG.get((String)"IAS_PERMISSION") + ":");
        this.name = new JTextField(20);
        JLabel descriptionL = new JLabel(LNG.get((String)"IAS_DESCRIPTION") + ":");
        this.description = new JTextField(20);
        JLabel permissionClassL = new JLabel(LNG.get((String)"IAS_PERMISSION_CLASS") + ":");
        this.permissionClass = this.makeClassComboBox();
        this.permissionClass.setSelectedIndex(-1);
        this.permissionClassDesc = this.makePermissionClassDescription(this.permissionClass);
        GBC gbc = new GBC(0, 0).northwest().insets(5, 0, 10, 5);
        panel.add((Component)nameL, gbc);
        gbc = new GBC(1, 0).horizontal().insets(0, 0, 5, 0).filly();
        panel.add((Component)this.name, gbc);
        gbc = new GBC(0, 1).northwest().insets(5, 0, 10, 5);
        panel.add((Component)descriptionL, gbc);
        gbc = new GBC(1, 1).horizontal().insets(0, 0, 5, 0).filly();
        panel.add((Component)this.description, gbc);
        gbc = new GBC(0, 2).northwest().insets(5, 0, 0, 5);
        panel.add((Component)permissionClassL, gbc);
        gbc = new GBC(1, 2).horizontal().insets(0, 0, 5, 0).filly();
        panel.add((Component)this.permissionClass, gbc);
        gbc = new GBC(1, 3).weights(1.0, 2.0).northwest().insets(5, 0, 0, 0).fillxy().both();
        JScrollPane scrollDesc = new JScrollPane(this.permissionClassDesc);
        scrollDesc.setBorder(null);
        panel.add((Component)scrollDesc, gbc);
        return panel;
    }

    private JComboBox makeClassComboBox() {
        final JComboBox<PermissionClassName> combo = new JComboBox<PermissionClassName>();
        Vector<String> classes = PermissionProxy.getPermissionClasses(this, this.windowLabel, LNG.get((String)"IAS_WAITING_ALL_PERMISSION_CLASSES"));
        Vector<PermissionClassName> classesNames = null;
        try {
            classesNames = this.makePermissionClassNames(classes);
            Collections.sort(classesNames);
            int classesSize = classesNames.size();
            for (int i = 0; i < classesSize; ++i) {
                combo.addItem(classesNames.get(i));
            }
            if (classesSize > 0) {
                combo.setSelectedIndex(0);
            }
            combo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (combo.getSelectedIndex() > -1) {
                        Object item = evt.getItem();
                        int stateChange = evt.getStateChange();
                        PermissionInfoDialog.this.classStateChanged(item, stateChange);
                    }
                }
            });
            combo.setEnabled(this.isNew);
        }
        catch (Exception e) {
            combo.setEditable(false);
            StandardErrorDialogs.showErrorDialog((Window)this, LNG.get((String)"ERRO") + " - " + this.windowLabel, (Throwable)e);
        }
        return combo;
    }

    private Vector<PermissionClassName> makePermissionClassNames(Vector<String> listClasses) throws ClassNotFoundException {
        if (listClasses == null) {
            return null;
        }
        Vector<PermissionClassName> listClassNames = new Vector<PermissionClassName>();
        for (int i = 0; i < listClasses.size(); ++i) {
            listClassNames.add(new PermissionClassName(listClasses.get(i)));
        }
        return listClassNames;
    }

    private boolean classStateChanged(Object item, int stateChange) {
        PermissionClassName permissionClassName = (PermissionClassName)item;
        if (permissionClassName == null) {
            return false;
        }
        this.permissionClassDesc.setText(this.getPermissionClassDescription(permissionClassName));
        this.permissionClassDesc.setCaretPosition(0);
        this.selectedPermissionClass = permissionClassName.getSuperClassName();
        if (this.selectedPermissionClass == null) {
            StandardErrorDialogs.showErrorDialog((Window)this, LNG.get((String)"PermissionInfoDialog.error.msg.permission_class_not_found"));
            return false;
        }
        if (stateChange == 1) {
            if (this.permissionAtributePanels.getCurrentCardName().equals(this.selectedPermissionClass) && this.selectedPermissionClass.equals(CHOICE_PERMISSION_CLASS)) {
                this.permissionAtributePanels.show(SIMPLE_PERMISSION_CLASS);
            }
            this.permissionAtributePanels.show(this.selectedPermissionClass);
            if (this.selectedPermissionClass != SIMPLE_PERMISSION_CLASS) {
                ((AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard()).changeClass();
            }
            this.rootPane.revalidate();
        }
        this.pack();
        return true;
    }

    private String getPermissionClassDescription(PermissionClassName item) {
        String desc = "";
        if (item != null) {
            desc = LNG.get((String)(item.getClassName() + DESCRIPTION_SUFFIX));
        }
        return desc;
    }

    private JTextArea makePermissionClassDescription(JComboBox combo) {
        JTextArea textArea = new JTextArea(5, 30);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(false);
        textArea.setEnabled(false);
        textArea.setBorder(null);
        textArea.setCaretPosition(0);
        textArea.setDisabledTextColor(Color.BLACK);
        textArea.setFont(textArea.getFont().deriveFont(0));
        textArea.setBackground(UIManager.getDefaults().getColor("TextField.inactiveBackground"));
        return textArea;
    }

    protected void initFields() {
        KeyAdapter keyChangeListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PermissionInfoDialog.this.checkDataChange();
            }
        };
        if (!this.isNew) {
            this.name.setText(this.permission.getName());
            this.description.setText(this.permission.getDescription());
            PermissionClassName className = null;
            try {
                className = new PermissionClassName(this.permission.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                StandardErrorDialogs.showErrorDialog((Window)this, LNG.get((String)"ERRO") + " - " + this.windowLabel, (Throwable)e);
            }
            if (className != null) {
                this.permissionClass.setSelectedItem(className);
            }
            this.name.addKeyListener(keyChangeListener);
            this.description.addKeyListener(keyChangeListener);
            if (!this.classStateChanged(this.permissionClass.getSelectedItem(), 1)) {
                StandardErrorDialogs.showErrorDialog((Window)this, LNG.get((String)"PermissionInfoDialog.error.msg.permission_class_not_found"));
                return;
            }
            this.permissionAtributePanels.show(this.selectedPermissionClass);
            if (!this.selectedPermissionClass.equals(SIMPLE_PERMISSION_CLASS)) {
                AbstractPermissionPanel permissionPanel = (AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard();
                permissionPanel.importFrom(this.permission);
            }
        } else {
            this.permissionClass.setSelectedIndex(0);
        }
    }

    private JPanel makePermissionsButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.previousButton);
        panel.add(this.nextButton);
        return panel;
    }

    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        if (this.isNew) {
            buttonPanel.add(this.makeAddPermissionButton());
            buttonPanel.add(this.makeCancelButton());
        } else {
            buttonPanel.add(this.makeChangeButton());
            buttonPanel.add(this.makeCloseButton());
        }
        return buttonPanel;
    }

    protected JButton makeAddPermissionButton() {
        this.includePermissionButton = new JButton(LNG.get((String)"IAS_INCLUDE"));
        this.includePermissionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                switch (PermissionInfoDialog.this.validateFields()) {
                    case FIELDS_OK: {
                        PermissionInfoDialog.this.createPermission();
                        break;
                    }
                    case EMPTY_FIELDS: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                        break;
                    }
                    case PASSWORDS_DONT_MATCH: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_PASSWORD_ERROR"));
                        break;
                    }
                    case ATTRIBUTES_ERROR: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_ATTRIBUTES_ERROR"));
                    }
                }
            }
        });
        return this.includePermissionButton;
    }

    protected JButton makeChangeButton() {
        this.includePermissionButton = new JButton(LNG.get((String)"IAS_PERMISSION_UPDATE"));
        this.includePermissionButton.setEnabled(false);
        this.includePermissionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                switch (PermissionInfoDialog.this.validateFields()) {
                    case FIELDS_OK: {
                        PermissionInfoDialog.this.modifyPermission();
                        PermissionInfoDialog.this.close();
                        break;
                    }
                    case EMPTY_FIELDS: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                        break;
                    }
                    case PASSWORDS_DONT_MATCH: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_PASSWORD_ERROR"));
                        break;
                    }
                    case ATTRIBUTES_ERROR: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_ATTRIBUTES_ERROR"));
                    }
                }
            }
        });
        return this.includePermissionButton;
    }

    protected JButton makeCancelButton() {
        JButton cancelButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                PermissionInfoDialog.this.close();
            }
        });
        return cancelButton;
    }

    protected JButton makeCloseButton() {
        JButton closeButton = new JButton(LNG.get((String)"IAS_CLOSE"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int selected;
                if (!PermissionInfoDialog.this.hasChanged() || PermissionInfoDialog.this.isEmpty()) {
                    PermissionInfoDialog.this.close();
                    return;
                }
                Object[] options = new Object[]{LNG.get((String)"IAS_UPDATE"), LNG.get((String)"IAS_CANCEL")};
                if (options[selected = JOptionPane.showOptionDialog(PermissionInfoDialog.this, LNG.get((String)"IAS_PERMISSION_UPDATE_CONFIRMATION"), PermissionInfoDialog.this.windowLabel, -1, 1, null, options, options[0])] == LNG.get((String)"IAS_CANCEL")) {
                    PermissionInfoDialog.this.close();
                    return;
                }
                switch (PermissionInfoDialog.this.validateFields()) {
                    case FIELDS_OK: {
                        PermissionInfoDialog.this.modifyPermission();
                        PermissionInfoDialog.this.close();
                        break;
                    }
                    case EMPTY_FIELDS: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_FILL_ALL_FIELDS"));
                        break;
                    }
                    case PASSWORDS_DONT_MATCH: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_PASSWORD_ERROR"));
                        break;
                    }
                    case ATTRIBUTES_ERROR: {
                        StandardErrorDialogs.showErrorDialog((Window)PermissionInfoDialog.this, PermissionInfoDialog.this.windowLabel, LNG.get((String)"IAS_CONFIRM_PERMISSION_ATTRIBUTES_ERROR"));
                    }
                }
            }
        });
        return closeButton;
    }

    protected FieldsState validateFields() {
        String nameText = this.name.getText().trim();
        if (nameText.equals("") || this.selectedPermissionClass == null) {
            return FieldsState.EMPTY_FIELDS;
        }
        if (this.selectedPermissionClass != SIMPLE_PERMISSION_CLASS) {
            AbstractPermissionPanel permissionPanel = (AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard();
            return permissionPanel.validateFields();
        }
        return FieldsState.FIELDS_OK;
    }

    private void clearFields() {
        if (this.isNew) {
            this.permission = null;
        }
        this.name.setText("");
        this.description.setText("");
        if (this.selectedPermissionClass != SIMPLE_PERMISSION_CLASS) {
            ((AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard()).clearFields();
        }
        this.name.requestFocus();
    }

    void checkDataChange() {
        if (this.hasChanged()) {
            this.includePermissionButton.setEnabled(true);
        } else {
            this.includePermissionButton.setEnabled(false);
        }
    }

    private boolean hasChanged() {
        if (!this.name.getText().trim().equals(this.permission.getName())) {
            return true;
        }
        if (!this.description.getText().trim().equals(this.permission.getDescription())) {
            return true;
        }
        if (this.selectedPermissionClass == null) {
            return false;
        }
        if (!this.selectedPermissionClass.equals(SIMPLE_PERMISSION_CLASS)) {
            return ((AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard()).hasChanged(this.permission);
        }
        return false;
    }

    private boolean isEmpty() {
        return this.name.getText().trim().equals("") && this.description.getText().trim().equals("");
    }

    public Permission getScreenPermission() {
        Permission screenPermission = null;
        String nameText = this.name.getText().trim();
        String descriptionText = this.description.getText().trim();
        PermissionClassName item = (PermissionClassName)this.permissionClass.getSelectedItem();
        try {
            Class<?> selectedClass = Class.forName(item.getClassName());
            Constructor<?> constructor = selectedClass.getConstructor(new Class[0]);
            screenPermission = (Permission)constructor.newInstance(new Object[0]);
            screenPermission.setName(nameText);
            screenPermission.setDescription(descriptionText);
            if (!this.selectedPermissionClass.equals(SIMPLE_PERMISSION_CLASS)) {
                ((AbstractPermissionPanel)this.permissionAtributePanels.getCurrentCard()).exportTo(screenPermission);
            }
        }
        catch (Exception e) {
            StandardErrorDialogs.showErrorDialog((Window)this, LNG.get((String)"ERRO") + " - " + this.windowLabel, (Throwable)e);
        }
        return screenPermission;
    }

    private void createPermission() {
        this.permission = this.getScreenPermission();
        if (this.permission == null) {
            return;
        }
        this.permission = PermissionProxy.createPermission(this, this.windowLabel, LNG.get((String)"IAS_WAITING_PERMISSION_CREATION"), this.permission);
        if (this.permission != null) {
            String msg = LNG.get((String)"IAS_PERMISSION_INCLUDED_WITH_SUCCESS");
            msg = MessageFormat.format(msg, this.permission.getName());
            StandardDialogs.showInfoDialog((Component)this, (String)this.windowLabel, (Object)msg);
            this.permission = null;
            this.clearFields();
        }
    }

    private void modifyPermission() {
        Permission modifiedPermission = this.getScreenPermission();
        if (modifiedPermission == null) {
            return;
        }
        modifiedPermission = PermissionProxy.modifyPermission(this, this.windowLabel, LNG.get((String)"IAS_WAITING_PERMISSION_MODIFICATION"), this.permission.getId(), modifiedPermission);
        if (modifiedPermission != null) {
            this.permission = modifiedPermission;
            StandardDialogs.showInfoDialog((Component)this, (String)this.windowLabel, (Object)MessageFormat.format(LNG.get((String)"IAS_PERMISSION_MODIFIED_WITH_SUCCESS"), this.permission.getName()));
            if (this.selectedPermissionClass.equals(USER_PASSWORD_PERMISSION_CLASS)) {
                ((UserPasswordPanel)this.permissionAtributePanels.getCurrentCard()).clearPasswordFields();
            }
            this.includePermissionButton.setEnabled(false);
        }
    }

    PermissionClassName getPermissionClassName() {
        return (PermissionClassName)this.permissionClass.getSelectedItem();
    }

    class PermissionClassName
    implements Comparable<PermissionClassName> {
        private String className;
        private String presentationName;
        private String superClassName;

        public PermissionClassName(String className) throws ClassNotFoundException {
            this.className = className;
            this.presentationName = LNG.get((String)className);
            this.superClassName = this.getSuperClassName(className);
        }

        private String getSuperClassName(String className) throws ClassNotFoundException {
            Class<?> permissionClass = Class.forName(className);
            Class<?> attributes = Class.forName(PermissionInfoDialog.ATTRIBUTES_PERMISSION_CLASS);
            Class<?> userPass = Class.forName(PermissionInfoDialog.USER_PASSWORD_PERMISSION_CLASS);
            Class<?> choicePermission = Class.forName(PermissionInfoDialog.CHOICE_PERMISSION_CLASS);
            if (attributes.isAssignableFrom(permissionClass)) {
                return PermissionInfoDialog.ATTRIBUTES_PERMISSION_CLASS;
            }
            if (userPass.isAssignableFrom(permissionClass)) {
                return PermissionInfoDialog.USER_PASSWORD_PERMISSION_CLASS;
            }
            if (choicePermission.isAssignableFrom(permissionClass)) {
                return PermissionInfoDialog.CHOICE_PERMISSION_CLASS;
            }
            return PermissionInfoDialog.SIMPLE_PERMISSION_CLASS;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getPresentationName() {
            return this.presentationName;
        }

        @Override
        public int compareTo(PermissionClassName o) {
            return this.presentationName.compareTo(o.presentationName);
        }

        public boolean equals(Object o) {
            return o instanceof PermissionClassName && ((PermissionClassName)o).presentationName.equals(this.presentationName);
        }

        public int hashCode() {
            if (this.presentationName == null) {
                return "presentationName is null".hashCode();
            }
            return this.presentationName.hashCode();
        }

        public String toString() {
            return this.presentationName;
        }
    }

    static enum FieldsState {
        FIELDS_OK,
        EMPTY_FIELDS,
        PASSWORDS_DONT_MATCH,
        ATTRIBUTES_ERROR;

    }
}

