/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.ProjectTree;
import csbase.client.project.action.ProjectAction;
import csbase.client.project.dialogs.PublishProjectDialog;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.CommonClientProject;
import csbase.logic.ProjectPermissions;
import csbase.logic.User;
import csbase.logic.UserOutline;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public class ProjectUsersManagementAction
extends ProjectAction {
    @Override
    public void actionPerformed(ActionEvent e) {
        RemoteTask<List<UserOutline>> task = new RemoteTask<List<UserOutline>>(){

            protected final void performTask() throws Exception {
                this.setResult(User.getAllOutlines());
            }

            @Override
            protected final void handleError(Exception exception) {
                if (exception instanceof RemoteException) {
                    super.handleError(exception);
                } else {
                    StandardErrorDialogs.showErrorDialog(this.parentWindow, this.taskTitle, (Throwable)exception);
                }
            }
        };
        if (task.execute(this.getWindow(), this.getName(), MessageFormat.format(LNG.get((String)"PRJ_WAITING_USERS_FROM_PRJ"), this.getCurrentProject().getName()))) {
            List allUsers = (List)task.getResult();
            CommonClientProject currentProject = this.getCurrentProject();
            PublishProjectDialog dialog = new PublishProjectDialog(DesktopFrame.getInstance().getDesktopFrame(), currentProject, allUsers, currentProject.getUsersRO(), currentProject.getUsersRW());
            if (dialog.execute()) {
                this.updateProject(dialog.getSharingType(), dialog.getUsersRO(), dialog.getUsersRW());
            }
        }
    }

    private void updateProject(final ProjectPermissions.SharingType sharingType, final Set<Object> usersRO, final Set<Object> usersRW) {
        final CommonClientProject project = this.getCurrentProject();
        RemoteTask<Void> task = new RemoteTask<Void>(){

            public void performTask() throws Exception {
                project.updateUsers(sharingType, usersRO, usersRW);
            }
        };
        if (!task.execute(this.getWindow(), this.getName(), MessageFormat.format(LNG.get((String)"PRJ_WAITING_USERS_MNG"), project.getName()))) {
            StandardErrorDialogs.showErrorDialog(this.getWindow(), this.getName(), MessageFormat.format(LNG.get((String)"PRJ_PROJECT_USERS_MNG_ERROR"), project.getName()));
        }
    }

    @Override
    public String getName() {
        return LNG.get((String)"PRJ_PROJECT_USERS_MNG_TITLE");
    }

    public ProjectUsersManagementAction(ProjectTree treeView) {
        super(treeView);
    }
}

