/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.remote.srvproxies.messageservice.consumers;

import csbase.client.remote.srvproxies.messageservice.consumers.IMessageConsumer;
import csbase.remote.IRemoteMessageListener;
import csbase.remote.MessageServiceInterface;
import csbase.util.messages.Message;
import csbase.util.rmi.PortReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import tecgraf.javautils.core.filter.IFilter;

public class MessageListenerConsumer
implements IMessageConsumer {
    private MessageServiceInterface service;
    private PortReference portRef;
    private IRemoteMessageListener messageListener;
    private IMessageConsumer.IListener listener;
    private IFilter<Message> filter;
    private AtomicBoolean started;
    private ExecutorService executor;

    public MessageListenerConsumer(MessageServiceInterface service, PortReference portRef) {
        if (service == null) {
            throw new IllegalArgumentException("service == null");
        }
        if (!portRef.isBound()) {
            throw new IllegalArgumentException("no port reserved");
        }
        this.service = service;
        this.portRef = portRef;
        this.started = new AtomicBoolean(false);
        this.executor = Executors.newSingleThreadExecutor();
        this.messageListener = new IRemoteMessageListener(){

            public void onMessagesReceived(final Message ... messages) throws RemoteException {
                final IMessageConsumer.IListener receiver = MessageListenerConsumer.this.listener;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        receiver.onMessagesReceived(messages);
                    }
                };
                MessageListenerConsumer.this.executor.execute(runnable);
            }
        };
    }

    @Override
    public synchronized void setListener(IMessageConsumer.IListener listener, IFilter<Message> filter) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        this.listener = listener;
        this.filter = filter;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    IFilter filter = MessageListenerConsumer.this.filter;
                    if (MessageListenerConsumer.this.started.compareAndSet(false, true)) {
                        MessageListenerConsumer.this.portRef.exportObject((Remote)MessageListenerConsumer.this.messageListener);
                        MessageListenerConsumer.this.service.setMessageListener(MessageListenerConsumer.this.messageListener, filter);
                    } else {
                        MessageListenerConsumer.this.service.clearMessageListener();
                        MessageListenerConsumer.this.service.setMessageListener(MessageListenerConsumer.this.messageListener, filter);
                    }
                }
                catch (Exception e) {
                    MessageListenerConsumer.this.listener.onExceptionThrown(e);
                }
            }
        };
        this.executor.execute(task);
    }

    @Override
    public synchronized void clearListener() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (MessageListenerConsumer.this.started.compareAndSet(true, false)) {
                    try {
                        MessageListenerConsumer.this.service.clearMessageListener();
                        MessageListenerConsumer.this.portRef.unexportObject((Remote)MessageListenerConsumer.this.messageListener, true);
                    }
                    catch (Exception e) {
                        MessageListenerConsumer.this.listener.onExceptionThrown(e);
                    }
                }
            }
        };
        this.executor.execute(task);
    }
}

