/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.rest;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.NotificationPanel;
import csbase.client.login.UserPasswordLogin;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.rest.RestController;
import csbase.exception.CSBaseException;
import csbase.logic.Session;
import csbase.remote.UserPasswordAuthenticator;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import tecgraf.javautils.core.lng.LNG;

@Provider
public class AuthFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final RestController restController = RestController.getInstance();

    private static WebApplicationException buildUnauthorizedResponse(String message) {
        String realmStr = "Basic realm=\"CSBaseClientRestController\"";
        return new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"CSBaseClientRestController\"").entity((Object)message).build());
    }

    public void filter(ContainerRequestContext containerRequestContext) throws WebApplicationException {
        if (restController.isDeveloperMode()) {
            return;
        }
        String auth = containerRequestContext.getHeaderString("Authorization");
        if (auth == null) {
            String msg = LNG.get((String)"csbase.client.rest.no.authorization.token");
            throw AuthFilter.buildUnauthorizedResponse(msg);
        }
        if (auth.startsWith("Basic")) {
            if (!(restController.getUserLogin() instanceof UserPasswordLogin)) {
                throw AuthFilter.buildUnauthorizedResponse("Invalid login type");
            }
            auth = auth.replaceFirst("[Bb]asic ", "");
            String userColonPass = new String(Base64.getDecoder().decode(auth));
            String[] clientAuth = userColonPass.split(":");
            if (clientAuth.length != 2) {
                throw AuthFilter.buildUnauthorizedResponse("Invalid Authorization header");
            }
            String login = clientAuth[0];
            String passwd = clientAuth[1];
            if (!ClientRemoteMonitor.getInstance().getLogin().equals(login)) {
                throw AuthFilter.buildUnauthorizedResponse("Different user is logged in");
            }
            try {
                UserPasswordAuthenticator authenticator = new UserPasswordAuthenticator(login, passwd, Locale.getDefault());
                Session authenticate = authenticator.authenticate(ClientServerManager.getInstance().getServer());
                if (authenticate == null) {
                    throw AuthFilter.buildUnauthorizedResponse("Invalid user/password");
                }
            }
            catch (CSBaseException e) {
                e.printStackTrace();
                throw AuthFilter.buildUnauthorizedResponse(e.getLocalizedMessage());
            }
            return;
        }
        if (auth.startsWith("Bearer")) {
            if (!restController.isTokenAuthorized(auth = auth.replaceFirst("[Bb]earer ", ""))) {
                String msg = LNG.get((String)"csbase.client.rest.invalid.authorization.token");
                throw AuthFilter.buildUnauthorizedResponse(msg);
            }
            return;
        }
        throw AuthFilter.buildUnauthorizedResponse("Uknown Authorization method");
    }

    public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws WebApplicationException {
        containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
        if (restController.isDeveloperMode()) {
            NotificationPanel notificationPanel = DesktopFrame.getInstance().getNotificationPanel();
            String method = containerRequestContext.getMethod();
            String uri = containerRequestContext.getUriInfo().getAbsolutePath().toString();
            int status = containerResponseContext.getStatus();
            String statusStr = containerResponseContext.getStatusInfo().toString();
            String msg = "[DEV-MODE] Requisi\u00e7\u00e3o REST: " + method + " " + uri + " -> " + status + " " + statusStr;
            notificationPanel.addNotificationLine(notificationPanel.makeNotificationLine(new Date(), "ClientRestService", msg, true));
        }
    }
}

