/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.actions;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction;
import csbase.client.applications.algorithmsmanager.report.core.ITest;
import csbase.client.applications.algorithmsmanager.report.core.ITestResult;
import csbase.client.applications.algorithmsmanager.report.core.ReportDialog;
import csbase.client.applications.algorithmsmanager.report.core.TestRunner;
import csbase.client.applications.algorithmsmanager.report.core.TestSelectionDialog;
import csbase.client.applications.algorithmsmanager.report.implementations.AlgorithmManagerSubjectFactory;
import csbase.client.applications.algorithmsmanager.report.implementations.TestConfiguratorInvalid;
import csbase.client.applications.algorithmsmanager.report.implementations.TestMissingPlatform;
import csbase.client.applications.algorithmsmanager.report.implementations.TestOutdatedFlow;
import csbase.logic.Platform;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RunTestsAction
extends AlgorithmsManagerAction {
    public RunTestsAction(AlgorithmsManager application) {
        super(application);
    }

    @Override
    protected void handleActionPerformed(ActionEvent ae) throws Exception {
        List<ITest<?>> allTests = this.buildAllTests();
        ApplicationFrame frame = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        TestSelectionDialog selectionDialog = new TestSelectionDialog(allTests, ((AlgorithmsManager)this.getApplication()).getLocale(), ((AlgorithmsManager)this.getApplication()).getApplicationFrame());
        selectionDialog.setVisible(true);
        List<Boolean> selection = selectionDialog.getSelection();
        if (selection == null) {
            return;
        }
        List<ITest<?>> selectedTests = this.buildSelection(allTests, selection);
        AlgorithmManagerSubjectFactory subjectFactory = new AlgorithmManagerSubjectFactory((Application)this.getApplication());
        TestRunner testRunner = new TestRunner(subjectFactory, ((AlgorithmsManager)this.getApplication()).getApplicationFrame(), ((AlgorithmsManager)this.getApplication()).getClassString(this.getClass(), "running.algorithms.tests.title"), ((AlgorithmsManager)this.getApplication()).getClassString(this.getClass(), "running.algorithms.tests.message"));
        Map<ITest<?>, ITestResult<?>> map = testRunner.run(selectedTests);
        ReportDialog dialog = new ReportDialog(map, ((AlgorithmsManager)this.getApplication()).getLocale(), frame);
        dialog.setVisible(true);
    }

    private List<ITest<?>> buildAllTests() throws Exception {
        ApplicationFrame frame = ((AlgorithmsManager)this.getApplication()).getApplicationFrame();
        ArrayList allTests = new ArrayList();
        allTests.add(new TestOutdatedFlow(frame));
        allTests.add(new TestMissingPlatform(Platform.getAllPlatforms(), frame));
        allTests.add(new TestConfiguratorInvalid(frame));
        return allTests;
    }

    private List<ITest<?>> buildSelection(List<ITest<?>> allTests, List<Boolean> selection) {
        ArrayList selectedTests = new ArrayList();
        for (int i = 0; i < allTests.size(); ++i) {
            if (!selection.get(i).booleanValue()) continue;
            selectedTests.add(allTests.get(i));
        }
        return selectedTests;
    }
}

