package csbase.client.applications.algorithmsmanager.actions;

import java.awt.event.ActionEvent;

import javax.swing.ImageIcon;

import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.CommonEditTabbedPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonManagementPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonSelectionPanel;

/**
 * Classe abstrata que define uma ao comum s funcionalidades de gerenciamento
 * de categorias e gerenciamento de algoritmos, na aplicao Gerenciador de
 * Algoritmos.
 * 
 * Essa ao realiza a criao de um painel de gerenciamento de dados.
 * 
 * Essa classe deve ser especializada para que construa o seu prprio painel de
 * gerenciamento de dados, especfico do dado a ser manipulado, como por
 * exemplo, categoria ou algoritmo. Isso  feito atravs da redefinio do
 * mtodo <code> createManagementPanel </code>.
 * 
 */
public abstract class CommonManagementAction extends AlgorithmsManagerAction {
  /**
   * Painel de gerenciamento dos dados a serem manipulados
   */
  private CommonManagementPanel managePanel;

  /**
   * Constri a ao de gerenciamento de dados.
   * 
   * @param application referncia para a aplicao
   * @param icon imagem da ao
   */
  public CommonManagementAction(AlgorithmsManager application, ImageIcon icon) {
    super(application, icon);
  }

  /**
   * (non-Javadoc)
   * 
   * @see csbase.client.applications.algorithmsmanager.actions.AlgorithmsManagerAction#handleActionPerformed(java.awt.event.ActionEvent)
   */
  @Override
  protected void handleActionPerformed(ActionEvent ae) throws Exception {
    initAction();
  }

  /**
   * Obtm o painel de gerenciamento dos dados.
   * 
   * @return o painel de gerenciamento dos dados
   */
  protected CommonManagementPanel getManagePanel() {
    return managePanel;
  }

  /**
   * Obtm o painel de seleo do(s) dado(s).
   * 
   * @return o painel de seleo dos dados
   */
  public CommonSelectionPanel getSelectionPanel() {
    return managePanel.getSelectionPanel();
  }

  /**
   * Obtm o painel de edio do dado.
   * 
   * @return o painel de edio do dado
   */
  public CommonEditTabbedPanel getEditPanel() {
    return managePanel.getEditPanel();
  }

  /**
   * Inicializa a ao de gerenciamento, selecionando o dado inicial a ser
   * exibido.
   */
  public void initAction() {
    if (managePanel == null) {
      managePanel = createManagementPanel(this);
      selectInitialData();
    }
    getApplication().changeMainPanel(managePanel);
  }

  /**
   * Atualiza o painel de gerenciamento dos dados.
   */
  public void updateToReload() {
    managePanel = null;
    initAction();
  }

  /**
   * Atualiza o painel de edio do dado.
   * 
   * Considerando que h uma diviso no painel de gerenciamento, o painel de
   * edio se localiza  direita.
   * 
   * Dependendendo da ao de gerenciamento selecionada, o painel de edio pode
   * permitir realizar a criao de um novo dado ou a atualizao do dado
   * corrente.
   * 
   * @param showInfo se true, indica que o painel de edio deve exibir as
   *        informaes pertinentes; se false, indica que nenhuma informao
   *        deve ser exibida (caso da exibio de um n raiz de uma rvore de
   *        categorias)
   */
  public void updateEditPanel(boolean showInfo) {
    managePanel.updateEditPanel(showInfo);
  }

  /**
   * Modifica o painel de edio do split para que contenha um determinado
   * painel de criao de um dado.
   * 
   * @param createPanel painel de criao de um dado
   */
  public void setCreatePanel(CommonEditTabbedPanel createPanel) {
    managePanel.setCreatePanel(createPanel);
  }

  /**
   * Cria o painel de gerenciamento dos dados a serem manipulados.
   * 
   * @param commonManagementAction ao de gerenciamento
   * @return o painel criado
   */
  protected abstract CommonManagementPanel createManagementPanel(
    CommonManagementAction commonManagementAction);

  /**
   * Seleciona um dado inicialmente para ser exibido.
   */
  protected abstract void selectInitialData();

}
