/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication.actions;

import csbase.client.algorithms.tasks.CreateFlowConfiguratorTask;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.FlowApplication;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.actions.MultipleExecutionAction;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.applications.flowapplication.graph.GraphElement;
import csbase.client.applications.flowapplication.graph.GraphFileDescriptor;
import csbase.client.applications.flowapplication.graph.GraphLink;
import csbase.client.applications.flowapplication.graph.GraphNode;
import csbase.client.applications.flowapplication.multiflow.MultiFlowWizard;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;
import java.awt.event.ActionEvent;

public final class MultipleExecuteGraphAction
extends MultipleExecutionAction {
    public MultipleExecuteGraphAction(FlowApplication application) {
        super(application, ApplicationImages.ICON_MULTIPLAY_16);
        this.setEnabled(false);
    }

    @Override
    public void handleActionPerformed(ActionEvent e) {
        FlowAlgorithmConfigurator configurator;
        FlowApplication application = (FlowApplication)this.getApplication();
        Workspace workspace = application.getWorkspace();
        Graph graph = workspace.getGraph();
        if (!graph.isExecutable()) {
            throw new IllegalStateException("O fluxo de algoritmos n\u00e3o est\u00e1 pronto para ser executado.");
        }
        Flow flow = graph.toFlow();
        flow.setName(application.getFlowName());
        flow.setDescription(application.getFlowDescription());
        MultiFlowWizard wizzard = new MultiFlowWizard(application);
        String[][] mapping = wizzard.configureMultipleExecution(flow);
        if (mapping != null && (configurator = CreateFlowConfiguratorTask.runTask(application.getApplicationFrame(), flow)) != null) {
            application.executeMultipleFlow(configurator, mapping);
        }
    }

    @Override
    public void wasChangedWorkspace(Graph graph) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementCreated(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementParametrized(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasElementRemoved(Graph graph, GraphElement element) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkAnchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkIncreased(Graph graph, GraphLink link) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkStatusChanged(Graph graph, GraphLink link) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasLinkUnanchored(Graph graph, GraphLink link, GraphFileDescriptor fileDescriptor) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasParameterSetEnabled(Graph graph, GraphNode node, String parameterName, boolean isEnabled) {
        this.updateEnabledStatus(graph);
    }

    @Override
    public void wasParameterSetVisible(Graph graph, GraphNode node, String parameterName, boolean isVisible) {
        this.updateEnabledStatus(graph);
    }

    private void updateEnabledStatus(Graph graph) {
        this.setEnabled(graph.isExecutable());
    }
}

