/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.columns;

import csbase.client.desktop.RemoteTask;
import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.logic.ClientFile;
import java.awt.Component;
import java.awt.Window;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.StandardDialogs;

public class DirectoryListingColumnGenerator
implements ColumnGenerator<String> {
    private ClientFile[] files;

    public DirectoryListingColumnGenerator(Window owner, ClientFile directory) {
        this.files = this.getChildren(owner, directory);
    }

    private ClientFile[] getChildren(Window owner, final ClientFile directory) {
        RemoteTask<ClientFile[]> task = new RemoteTask<ClientFile[]>(){

            protected void performTask() throws Exception {
                this.setResult(directory.getChildren());
            }
        };
        String lngPrefix = DirectoryListingColumnGenerator.class.getName();
        String title = LNG.get((String)(lngPrefix + ".task.title"));
        String message = LNG.get((String)(lngPrefix + ".task.message"), (Object[])new Object[]{directory});
        String error = LNG.get((String)(lngPrefix + ".task.error"), (Object[])new Object[]{directory});
        if (!task.execute(owner, title, message)) {
            StandardDialogs.showErrorDialog((Component)owner, (String)title, (String)error);
        }
        return (ClientFile[])task.getResult();
    }

    @Override
    public String getValueAt(int rowIndex) {
        if (this.files != null && rowIndex < this.files.length) {
            return this.files[rowIndex].getStringPath();
        }
        return null;
    }
}

