/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.commandsmonitor;

import csbase.client.applications.commandsmonitor.events.SelectionChangedEvent;
import csbase.client.facilities.commandtable.AbstractCommandMonitoringTable;
import csbase.client.util.event.EventManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UniqueTableSelectionManager {
    private EventManager eventManager;
    private AtomicBoolean ignoreEvents = new AtomicBoolean(false);
    private AbstractCommandMonitoringTable onFocusTable;
    private List<JTable> tables = new ArrayList<JTable>();
    private Map<JTable, ListSelectionListener> selectionListenersByTable = new HashMap<JTable, ListSelectionListener>();

    public UniqueTableSelectionManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void startManaging(AbstractCommandMonitoringTable table) {
        this.tables.add((JTable)((Object)table));
        ListSelectionListener listener = this.createListener(table);
        this.selectionListenersByTable.put((JTable)((Object)table), listener);
        table.getSelectionModel().addListSelectionListener(listener);
    }

    public void stopManaging(JTable table) {
        if (this.tables.remove(table)) {
            ListSelectionListener listener = this.selectionListenersByTable.get(table);
            table.getSelectionModel().removeListSelectionListener(listener);
            if (table.equals((Object)this.onFocusTable)) {
                this.onFocusTable = null;
            }
        }
    }

    public void clearSelections() {
        if (this.ignoreEvents.compareAndSet(false, true)) {
            for (JTable aTable : this.tables) {
                aTable.getSelectionModel().clearSelection();
            }
            this.onFocusTable = null;
            this.ignoreEvents.set(false);
            this.eventManager.fireEvent(new SelectionChangedEvent());
        }
    }

    public JTable getTableWithFocus() {
        return this.onFocusTable;
    }

    private ListSelectionListener createListener(final AbstractCommandMonitoringTable table) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!((Object)((Object)table)).equals((Object)UniqueTableSelectionManager.this.onFocusTable) && UniqueTableSelectionManager.this.ignoreEvents.compareAndSet(false, true)) {
                    UniqueTableSelectionManager.this.onFocusTable = table;
                    for (JTable aTable : UniqueTableSelectionManager.this.tables) {
                        if (((Object)((Object)table)).equals(aTable)) continue;
                        aTable.getSelectionModel().clearSelection();
                    }
                    UniqueTableSelectionManager.this.ignoreEvents.set(false);
                }
                if (!UniqueTableSelectionManager.this.ignoreEvents.get() && null != UniqueTableSelectionManager.this.onFocusTable) {
                    UniqueTableSelectionManager.this.eventManager.fireEvent(new SelectionChangedEvent(UniqueTableSelectionManager.this.onFocusTable.getSelectedCommands()));
                }
            }
        };
    }
}

