/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.flowapplication;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.text.MessageFormat;
import tecgraf.vix.VO;

public final class ImageVO
extends VO {
    private double bottomPadding;
    private double height;
    private Image image;
    private double leftPadding;
    private double rightPadding;
    private double topPadding;
    private double width;
    private double x;
    private double y;

    public ImageVO(Image image) {
        this.setImage(image);
        this.setWidth(this.image.getWidth(this.createImageObserver()));
        this.setHeight(this.image.getWidth(this.createImageObserver()));
    }

    public void callbackRepaint(Graphics2D g) {
        super.callbackRepaint(g);
        AffineTransform matrix = new AffineTransform(1.0, 0.0, 0.0, 1.0, this.getX() + this.rightPadding, this.getY() + this.topPadding);
        g.drawImage(this.image, matrix, this.createImageObserver());
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setBottomPadding(double bottomPadding) {
        if (bottomPadding <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro bottomPadding ({0}) tem que ser positivo.", bottomPadding);
            throw new IllegalArgumentException(errorMessage);
        }
        this.bottomPadding = bottomPadding;
        this.height += this.bottomPadding;
    }

    public void setCenterX(double x) {
        this.x = x - this.getWidth() / 2.0;
    }

    public void setCenterY(double y) {
        this.y = y - this.getHeight() / 2.0;
    }

    public void setLeftPadding(double leftPadding) {
        if (leftPadding <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro leftPadding ({0}) tem que ser positivo.", leftPadding);
            throw new IllegalArgumentException(errorMessage);
        }
        this.leftPadding = leftPadding;
        this.width += this.leftPadding;
    }

    public void setRightPadding(double rightPadding) {
        if (rightPadding <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro rightPadding ({0}) tem que ser positivo.", rightPadding);
            throw new IllegalArgumentException(errorMessage);
        }
        this.rightPadding = rightPadding;
        this.width += this.rightPadding;
    }

    public void setTopPadding(double topPadding) {
        if (topPadding <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro topPadding ({0}) tem que ser positivo.", topPadding);
            throw new IllegalArgumentException(errorMessage);
        }
        this.topPadding = topPadding;
        this.height += this.topPadding;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    private ImageObserver createImageObserver() {
        return new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int imgX, int imgY, int imgWidth, int imgHeight) {
                if ((infoflags & 2) == 2) {
                    ImageVO.this.setHeight(imgHeight);
                    return true;
                }
                if ((infoflags & 1) == 1) {
                    ImageVO.this.setWidth(imgWidth);
                    return true;
                }
                return (infoflags & 0x20) == 1;
            }
        };
    }

    private void setHeight(double height) {
        if (height <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro height ({0}) tem que ser positivo.", height);
            throw new IllegalArgumentException(errorMessage);
        }
        this.height = height;
    }

    private void setImage(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("O par\u00e2metro image est\u00e1 nulo.");
        }
        this.image = image;
    }

    private void setWidth(double width) {
        if (width <= 0.0) {
            String errorMessage = MessageFormat.format("O par\u00e2metro width ({0}) tem que ser positivo.", width);
            throw new IllegalArgumentException(errorMessage);
        }
        this.width = width;
    }
}

