/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.desktop;

import csbase.client.ClientServerManager;
import csbase.client.desktop.DesktopComponentDialog;
import csbase.client.desktop.DesktopFrame;
import csbase.client.desktop.RemoteTask;
import csbase.client.project.action.ProjectCloseAction;
import csbase.client.remote.ClientRemoteMonitor;
import csbase.client.remote.manager.server.ServerInfoManager;
import csbase.client.remote.manager.server.ServerInfoManagerListener;
import csbase.client.util.StandardErrorDialogs;
import csbase.client.util.gui.ComponentUtilities;
import csbase.exception.CSBaseException;
import csbase.logic.LoginInfo;
import csbase.logic.ServerURI;
import csbase.logic.server.ServerInfo;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.SwingThreadDispatcher;
import tecgraf.javautils.gui.table.AbstractColumn;
import tecgraf.javautils.gui.table.ColumnsObjectTableModel;
import tecgraf.javautils.gui.table.IColumn;
import tecgraf.javautils.gui.table.ObjectTableBuilder;
import tecgraf.javautils.gui.table.SortableTable;

public class ProjectServerDialog
extends DesktopComponentDialog {
    private SortableTable table;
    private ColumnsObjectTableModel<ServerInfo> tableModel;
    private ServerInfoManagerListener managerListener;

    private ProjectServerDialog(Window owner) {
        super(owner, LNG.get((String)"ProjectServerDialog.title"));
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.buildGUI());
        this.initializeServersListener();
    }

    public static void show(Window owner) {
        ProjectServerDialog dialog = new ProjectServerDialog(owner);
        dialog.pack();
        dialog.setVisible(true);
    }

    public JPanel buildGUI() {
        JButton closeButton = new JButton(new AbstractAction(LNG.get((String)"ProjectServerDialog.action.close.name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectServerDialog.this.close();
            }
        });
        final LoginAction loginAction = new LoginAction();
        loginAction.setEnabled(false);
        JButton loginButton = new JButton(loginAction);
        ObjectTableBuilder builder = new ObjectTableBuilder(new IColumn[]{new ConnectedColumn(), new SuspendedColumn(), new NameColumn(), new URIColumn()});
        builder.setColumnsWidthPolicy(ObjectTableBuilder.ColumnsWidthPolicy.ADJUST_BY_DATA);
        builder.setSelectionMode(ObjectTableBuilder.SelectionMode.SINGLE_SELECTION);
        builder.setSortOrder(2, SortOrder.DESCENDING);
        List<ServerInfo> servers = this.getServers();
        this.table = builder.build(servers);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServerInfo selected = ProjectServerDialog.this.getSelectedServer();
                if (selected == null) {
                    loginAction.setEnabled(false);
                }
                ClientServerManager serverManager = ClientServerManager.getInstance();
                ServerURI currentServer = serverManager.getDefaultURI();
                loginAction.setEnabled(selected != null && !currentServer.equals((Object)selected.getURI()) && !selected.isSuspended());
            }
        });
        this.tableModel = (ColumnsObjectTableModel)this.table.getModel();
        ComponentUtilities.setMaxPreferredSize(loginButton, closeButton);
        JPanel btnPanel = new JPanel(new FlowLayout(2));
        btnPanel.add(loginButton);
        btnPanel.add(closeButton);
        JPanel panel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0);
        gbc.center().fillxy().insets(12, 12, 11, 11);
        panel.add((Component)new JScrollPane((Component)this.table), gbc);
        gbc.gridy(1).east().horizontal().insets(0, 12, 11, 11);
        panel.add((Component)btnPanel, gbc);
        return panel;
    }

    @Override
    public void close() {
        if (ServerInfoManager.getInstance().isEnabled()) {
            ServerInfoManager.getInstance().removeServerInfoManagerListener(this.managerListener);
        }
        super.close();
    }

    private void initializeServersListener() {
        this.managerListener = new ServerInfoManagerListener(){

            @Override
            public void wasAddedServerInfo(final ServerInfo addedLocalServer) {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectServerDialog.this.tableModel.add((Object)addedLocalServer);
                    }
                });
            }

            @Override
            public void wasRemovedServerInfo(final ServerInfo removedLocalServer) {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectServerDialog.this.tableModel.remove((Object)removedLocalServer);
                    }
                });
            }

            @Override
            public void wasModifiedServerInfo(final ServerInfo oldLocalServer, final ServerInfo newLocalServer) {
                SwingThreadDispatcher.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ProjectServerDialog.this.tableModel.remove((Object)oldLocalServer);
                        ProjectServerDialog.this.tableModel.add((Object)newLocalServer);
                    }
                });
            }
        };
        if (ServerInfoManager.getInstance().isEnabled()) {
            ServerInfoManager.getInstance().addServerInfoManagerListener(this.managerListener);
        }
    }

    private List<ServerInfo> getServers() {
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        RemoteTask<Set<ServerInfo>> task = new RemoteTask<Set<ServerInfo>>(){

            protected void performTask() throws Exception {
                ServerInfoManager manager = ServerInfoManager.getInstance();
                this.setResult(manager.getServersInfos());
            }
        };
        if (task.execute(this, this.getTitle(), LNG.get((String)"ProjectServerDialog.task.getservers.text"))) {
            servers.addAll((Collection)task.getResult());
        }
        return servers;
    }

    private ServerInfo getSelectedServer() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        int rowIndex = this.table.convertRowIndexToModel(selectedRow);
        return (ServerInfo)this.tableModel.getRow(rowIndex);
    }

    private boolean login(final ServerInfo server) {
        final ClientServerManager serverManager = ClientServerManager.getInstance();
        RemoteTask<Integer> loginTask = new RemoteTask<Integer>(){

            protected void performTask() throws Exception {
                if (!serverManager.isMonitored(server.getURI())) {
                    LoginInfo loginInfo = ClientRemoteMonitor.getInstance().getLoginInfo();
                    if (!serverManager.loginWithUserPassword(server.getURI(), loginInfo)) {
                        this.setResult(1);
                        return;
                    }
                }
                if (!serverManager.isAlive(server.getURI())) {
                    serverManager.logout(server.getURI(), true);
                    this.setResult(2);
                } else {
                    this.setResult(0);
                }
            }

            @Override
            protected void handleError(Exception error) {
                if (CSBaseException.class.isAssignableFrom(error.getClass())) {
                    StandardErrorDialogs.showErrorDialog((Window)ProjectServerDialog.this, ProjectServerDialog.this.getTitle(), LNG.get((String)"ProjectServerDialog.task.login.error.3", (Object[])new Object[]{server.getName()}));
                } else {
                    super.handleError(error);
                }
            }
        };
        if (loginTask.execute(this, this.getTitle(), LNG.get((String)"ProjectServerDialog.task.login.text", (Object[])new Object[]{server.getName()}))) {
            Integer responseCode = (Integer)loginTask.getResult();
            if (responseCode == 0) {
                return true;
            }
            StandardErrorDialogs.showErrorDialog((Window)this, this.getTitle(), LNG.get((String)("ProjectServerDialog.task.login.error." + responseCode), (Object[])new Object[]{server.getName()}));
            return false;
        }
        return false;
    }

    private boolean changeServer(final ServerInfo connectedServer) {
        final ClientServerManager serverManager = ClientServerManager.getInstance();
        final ServerURI oldServerURI = serverManager.getDefaultURI();
        RemoteTask<Void> login = new RemoteTask<Void>(){

            protected void performTask() {
                serverManager.setDefaultServer(connectedServer.getURI());
                serverManager.logout(oldServerURI, true);
            }
        };
        return login.execute(this, this.getTitle(), LNG.get((String)"ProjectServerDialog.task.changeserver.text"));
    }

    class URIColumn
    extends AbstractColumn<ServerInfo> {
        protected URIColumn() {
            super(String.class);
        }

        public String getColumnName() {
            return LNG.get((String)"ProjectServerDialog.column.uri.name");
        }

        public Object getValue(ServerInfo obj) {
            return obj.getURI().toString();
        }
    }

    class NameColumn
    extends AbstractColumn<ServerInfo> {
        protected NameColumn() {
            super(String.class);
        }

        public String getColumnName() {
            return LNG.get((String)"ProjectServerDialog.column.name.name");
        }

        public Object getValue(ServerInfo obj) {
            return obj.getName();
        }
    }

    class ConnectedColumn
    extends AbstractColumn<ServerInfo> {
        protected ConnectedColumn() {
            super(Boolean.class);
        }

        public String getColumnName() {
            return LNG.get((String)"ProjectServerDialog.column.connected.name");
        }

        public Object getValue(ServerInfo obj) {
            ClientServerManager serverManager = ClientServerManager.getInstance();
            ServerURI currentServerURI = serverManager.getDefaultURI();
            return currentServerURI.equals((Object)obj.getURI());
        }
    }

    class SuspendedColumn
    extends AbstractColumn<ServerInfo> {
        protected SuspendedColumn() {
            super(Boolean.class);
        }

        public String getColumnName() {
            return LNG.get((String)"ProjectServerDialog.column.suspended.name");
        }

        public Object getValue(ServerInfo obj) {
            return obj.isSuspended();
        }
    }

    class LoginAction
    extends AbstractAction {
        public LoginAction() {
            super(LNG.get((String)"ProjectServerDialog.action.login.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServerInfo selected = ProjectServerDialog.this.getSelectedServer();
            ClientServerManager serverManager = ClientServerManager.getInstance();
            ServerURI oldServer = serverManager.getDefaultURI();
            if (oldServer.equals((Object)selected.getURI())) {
                return;
            }
            if (!ProjectServerDialog.this.login(selected)) {
                return;
            }
            if (!new ProjectCloseAction(DesktopFrame.getInstance().getTree()).close()) {
                return;
            }
            if (ProjectServerDialog.this.changeServer(selected)) {
                List servers = ProjectServerDialog.this.getServers();
                ProjectServerDialog.this.tableModel.setRows(servers);
            }
        }
    }
}

