/*
 * Detalhes da ltima alterao:
 * 
 * $Author: clinio $
 * $Date: 2010-08-10 19:24:48 -0300 (Tue, 10 Aug 2010) $
 * $Revision: 108911 $
 */
package csbase.client;

import java.rmi.RemoteException;

import javax.swing.JFrame;

import csbase.client.kernel.ClientException;
import csbase.client.login.InitialContext;

/**
 * <p>
 * Representa uma interface de usurio que ser executado pelo cliente.
 * </p>
 * <p>
 * OBS: Toda classe que deseja ser uma interface de usurio deve possuir um
 * construtor que no receba parmetros.
 * </p>
 * 
 * @author Tecgraf/PUC-Rio
 */
public interface ClientUI {
  /**
   *  chamado para inicializar a interface de usurio, antes que a interface
   * seja exibida.
   * 
   * @param initialContext O contexto inicial de execuo da interface de
   *        usurio.
   * 
   * @throws RemoteException Em caso de falha na comunicao com o cliente
   * @throws ClientException Caso ocorra algum problema ao iniciar a interface
   *         de usurio.
   */
  void preInitialization(InitialContext initialContext) throws RemoteException, ClientException;

  /**
   * Exibe a interface de usurio.
   */
  void showUI();

  /**
   *  chamado para inicializar a interface de usurio, quando a interface j
   * est sendo exibida.
   * @throws Exception em caso de erro.
   */
  void postInitialization() throws Exception;

  /**
   * Obtm o componente grfico concreto que representa esta UI.
   * 
   * @return O componente grfico concreto.
   */
  JFrame getView();
}
