package csbase.client.applications.algorithmsmanager.versiontree.actions;

/*
 * $Id$
 */

import java.awt.Window;

import javax.swing.AbstractAction;
import javax.swing.Action;

import csbase.client.applications.algorithmsmanager.versiontree.VersionTree;

/**
 * @author Tecgraf / PUC-Rio
 * 
 *         Ao abstrata de um n da rvore de algoritmo.
 */
public abstract class AbstractVersionTreeNodeAction extends AbstractAction {

  // rvore que detm o n fonte da ao.
  private VersionTree tree;

  /**
   * Construtor.
   * 
   * @param tree rvore que detm o n fonte da ao.
   * @param name Nome da ao.
   */
  public AbstractVersionTreeNodeAction(VersionTree tree, String name) {
    super(name);

    this.tree = tree;
  }

  /**
   * Obtm o nome da ao.
   * 
   * @return nome da ao.
   */
  public String getName() {
    return (String) getValue(Action.NAME);
  }

  /**
   * Obtm a janela que criou a rvore.
   * 
   * @return a janela que criou a rvore.
   */
  protected Window getWindow() {
    return tree.getOwner();
  }

  /**
   * Obtm a rvore que detm o n fonte da ao.
   * 
   * @return a rvore que detm o n fonte da ao.
   */
  protected VersionTree getTree() {
    return this.tree;
  }
}
