/*
 * $Id$
 */

package csbase.client.applications.commandsmonitor.table.column;

import java.awt.Component;
import java.util.Locale;

import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import tecgraf.javautils.core.lng.FormatUtils;
import csbase.logic.CommandInfo;
import csbase.logic.applicationservice.ApplicationRegistry;

/**
 * Coluna contendo o tempo de execuo do comando.
 * 
 * @author Tecgraf / PUC-Rio
 */
public class ElapsedColumn extends AbstractCommandsTableColumn {

  /**
   * Construtor.
   * 
   * @param id Identificador da coluna.
   * @param appRegistry registro da aplicao que ser utilizado para se obter o
   *        nome da coluna de acordo com o {@link Locale}.
   */
  public ElapsedColumn(String id, ApplicationRegistry appRegistry) {
    super(Double.class, id, appRegistry);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getValue(CommandInfo cmd) {
    return cmd.getWallTimeSec();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public TableCellRenderer createTableCellRenderer() {
    return new DefaultTableCellRenderer() {
      @Override
      public Component getTableCellRendererComponent(JTable table,
        Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        super.getTableCellRendererComponent(table, value, isSelected, hasFocus,
          row, column);

        if (value == null) {
          setText(getDefaultEmptyValue());
        }
        else {
          final int wtime = (Integer) value;
          if (wtime < 0) {
            setText(getDefaultErrorValue());
          }
          else {
            final String text = FormatUtils.formatInterval(wtime);
            setText(text);
          }
        }
        return this;
      }
    };
  }
}
