package csbase.client.applications.flowapplication.graph;

import tecgraf.vix.VO;

/**
 * Representa uma decorao (um VO + dica textual) de um n do grafo.
 * 
 * @param <T> O tipo de VO que representa a decorao.
 */
public interface GraphNodeDecoration<T extends VO> {

  /**
   * Retorna a descrio da decorao
   * 
   * @return description A descrio
   */
  public abstract String getDescription();

  /**
   * Retorna o VO que representa a decorao
   * 
   * @return image A imagem
   */
  public abstract T getVO();

  /**
   * Obtm a largura da decorao.
   * 
   * @return width a largura.
   */
  public abstract double getWidth();

  /**
   * Obtm a altura da decorao.
   * 
   * @return width a altura.
   */
  public abstract double getHeight();

  /**
   * Atribui o retngulo que representa a posio e tamanho da decorao.
   * 
   * @param rect o retngulo.
   */
  public abstract void setRectangle(java.awt.geom.Rectangle2D.Double rect);

}