package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddLinkPopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphLink;

/**
 * Ao de menu popup que quebra conexes entre ns do fluxo de algoritmos.
 * 
 * @author lmoreira
 */
public final class BreakLinkAction extends GraphElementAction {

  /**
   * Ponto
   */
  private final Point2D point;

  /**
   * Cria ao.
   * 
   * @param link A conexo (No aceita {@code null}).
   * @param point O ponto onde o menu-popup foi pedido (No aceita {@code null}
   *        ).
   */
  public BreakLinkAction(final GraphLink link, final Point2D point) {
    super(link, BreakLinkAction.class.getName() + ".name",
      ApplicationImages.ICON_PAUSE_16);
    this.point = (Point2D) point.clone();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    final GraphLink link = (GraphLink) getElement();
    if (link.breakPoint(this.point)) {
      link.repaint();
    }
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static WorkspaceFilter createFilter(final Workspace workspace) {
    return new AddLinkPopupActionFilter(workspace) {

      @Override
      protected Action createAction(final GraphLink graphLink,
        final Point2D point) {
        return new BreakLinkAction(graphLink, point);
      }
    };
  }
}
