package csbase.client.applications.flowapplication.graph.actions;

import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.flowapplication.Workspace;
import csbase.client.applications.flowapplication.filters.AddNodePopupActionFilter;
import csbase.client.applications.flowapplication.filters.WorkspaceFilter;
import csbase.client.applications.flowapplication.graph.GraphNode;

/**
 * Ao de menu popup que exibe os valores dos parmetros de um n de fluxo de
 * algoritmos.
 * 
 * @author lmoreira
 */
public final class ShowParameterValuesAction extends GraphElementAction {
  /**
   * Cria a ao.
   * 
   * @param node O n (No aceita {@code null}).
   */
  public ShowParameterValuesAction(final GraphNode node) {
    super(node, ShowParameterValuesAction.class.getName() + ".name",
      ApplicationImages.ICON_VIEWPARAMS_16);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void actionPerformed(final ActionEvent e) {
    final GraphNode node = (GraphNode) getElement();
    node.showParameterValues();
  }

  /**
   * Cria o filtro que cadastra a ao no menu popup.
   * 
   * @param workspace A rea de trabalho (No aceita {@code null}).
   * 
   * @return O filtro.
   */
  public static final WorkspaceFilter createFilter(final Workspace workspace) {
    if (workspace == null) {
      throw new IllegalArgumentException("O parmetro workspace est nulo.");
    }
    return new AddNodePopupActionFilter(workspace) {
      @Override
      protected Action createAction(final GraphNode node, final Point2D point) {
        return new ShowParameterValuesAction(node);
      }
    };
  }
}
