package csbase.client.applications.projectsmanager.proxy;

import csbase.client.applications.projectsmanager.ProjectsManager;
import csbase.client.applications.projectsmanager.models.ProjectsManagerData;
import csbase.client.applications.projectsmanager.proxy.core.ProjectsManagerTask;
import csbase.logic.ClientProjectFile;
import csbase.logic.CommonClientProject;
import csbase.remote.ClientRemoteLocator;
import csbase.remote.ProjectServiceInterface;

/**
 * Remote task para obteno de histrico de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 * 
 */
public class GetProjectHistoryTask extends ProjectsManagerTask<String> {

  /**
   * Dados do projeto a ter o histrico obtido.
   */
  private ProjectsManagerData projectsManagerData;

  /**
   * Construtor
   * 
   * @param projectsManager A aplicao
   * @param projectsManagerData Dados do projeto a ter o histrico obtido.
   */
  public GetProjectHistoryTask(ProjectsManager projectsManager,
    ProjectsManagerData projectsManagerData) {
    super(projectsManager);
    this.projectsManagerData = projectsManagerData;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    ProjectServiceInterface psi = ClientRemoteLocator.projectService;

    Object projectId = projectsManagerData.getProjectId();
    CommonClientProject project = psi.openProject(projectId, false);

    ClientProjectFile root = project.getRoot();
    String description = root.getDescription();

    setResult(description);
  }
}
