package csbase.client.applications.serverdiagnostic.monitor;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

import csbase.logic.diagnosticservice.Status;

/**
 * Representa um agrupamento de estados de monitorao.
 * 
 * @author Tecgraf PUC-Rio
 */
public class StatusGroup {

  /**
   * A lista de status que fazem parte desse grupamento.
   */
  private ArrayList<Status> statusList;

  /**
   * Nome do agrupamento.
   */
  private String groupName;

  /**
   * Mapa de recursos e seu renderer correspondente.
   */
  private Map<String, SwingRenderer> customRenderMap;

  /**
   * Construtor.
   * 
   * @param groupName o nome do grupamento
   */
  public StatusGroup(String groupName) {
    this.groupName = groupName;
    this.customRenderMap = new Hashtable<String, SwingRenderer>();
  }

  /**
   * Adiciona um status no grupamento.
   * 
   * @param status o status que faz parte desse grupamento
   */
  public void addStatus(Status status) {
    addStatus(status, null);
  }

  /**
   * Adiciona um status no grupamento.
   * 
   * @param status o status que faz parte desse grupamento
   * @param renderer o renderizador dos ns de status da rvore
   */
  public void addStatus(Status status, SwingRenderer renderer) {
    statusList.add(status);
    if (renderer != null) {
      customRenderMap.put(status.getResourceName(), renderer);
    }
  }

  /**
   * Obtm o nome do grupamento.
   * 
   * @return o nome do grupamento
   */
  public String getName() {
    return groupName;
  }

}
