/**
 * $Id: SwingRenderer.java 140813 2013-05-10 15:15:06Z fpina $
 */

package csbase.client.applications.serverdiagnostic.monitor;

import javax.swing.JComponent;

import csbase.logic.diagnosticservice.Status;

/**
 * Interface de renderer que exibe as informaes de um
 * {@link csbase.logic.diagnosticservice.Status} como componentes Swing.
 * 
 * @author Tecgraf
 */
public interface SwingRenderer {
  /**
   * Obtm as informaes bsicas de um estado.
   * 
   * @param status o estado
   * 
   * @return as informaes bsicas dentro de um JComponent
   */
  public JComponent getHeadline(Status status);

  /**
   * Obtm as informaes detalhadas de um estado.
   * 
   * @param status o estado
   * 
   * @return as informaes detalhadas dentro de um JComponent
   */
  public JComponent getDetails(Status status);
}
