/*
 * $Id: ProjectTreeNodeTypeComparator.java 68743 2007-10-08 19:47:07Z clinio $
 */

package csbase.client.project;

import java.util.Comparator;

import csbase.logic.ClientProjectFile;

/**
 * Representa um comparador de {@link csbase.client.project.ProjectTreeNode}
 * que utiliza o nome do n (na verdade, o nome do arquivo guardado pelo n).
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ProjectTreeNodeTypeComparator implements Comparator<ProjectTreeNode> {
  
  /**
   * A instncia
   */
  private static ProjectTreeNodeTypeComparator instance;

  /**
   * Construtor privado para singleton
   */
  private ProjectTreeNodeTypeComparator() {}

  /**
   * Busca do singleton
   * @return a instncia
   */
  public static ProjectTreeNodeTypeComparator getInstance() {
    if (ProjectTreeNodeTypeComparator.instance == null) {
      ProjectTreeNodeTypeComparator.instance =
        new ProjectTreeNodeTypeComparator();
    }
    return ProjectTreeNodeTypeComparator.instance;
  }

  /**
   * {@inheritDoc}
   */
  public int compare(ProjectTreeNode node1, ProjectTreeNode node2) {
    final ClientProjectFile file1 = node1.getClientProjectFile();
    final ClientProjectFile file2 = node2.getClientProjectFile();
    final boolean d1 = file1.isDirectory();
    final boolean d2 = file2.isDirectory();
    if (d1 != d2) {
      if (d1) return -1;
      else return 1;
    }
    final String typeName = file1.getType();
    final String typeName2 = file2.getType();
    return (typeName.compareTo(typeName2));   
  }
}
