package csbase.client.util.iostring;

import java.nio.charset.Charset;

import csbase.client.desktop.Task;
import csbase.logic.ClientFile;

/**
 * Task especfica para leitura
 * {@link TextReader#readAllWithoutTask(ClientFile, Charset, TextDealerStatusInterface)}
 * .
 * 
 * @author Tecgraf/PUC-Rio
 */
class WriterTask extends Task<Void> implements TextDealerStatusInterface {

  /**
   * Arquivo
   */
  final private ClientFile file;

  /**
   * Charset
   */
  final private Charset charset;

  /**
   * Texto a ser gravado.
   */
  final private String text;

  /**
   * {@inheritDoc}
   */
  @Override
  final protected void performTask() throws Exception {
    setProgressStatus(0);
    TextWriter.writeAllWithoutTask(file, text, charset, this);
  }

  /**
   * Construtor
   * 
   * @param file arquivo
   * @param text texto gravado.
   * @param charset charset
   */
  public WriterTask(final ClientFile file, final String text,
    final Charset charset) {
    this.file = file;
    this.charset = charset;
    this.text = text;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isTextOperationInterrupted() {
    return wasCancelled();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setTextOperationPercentage(int perc) {
    setProgressStatus(perc);
  }
}
