package csbase.client.algorithms.commands.newview;

import java.awt.Component;

import tecgraf.javautils.gui.StatusBar;
import csbase.client.algorithms.commands.cache.events.CommandUpdatedEvent.Type;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.kernel.ClientException;
import csbase.client.util.gui.log.tab.Tab;
import csbase.client.util.gui.log.tab.AbstractTab.TabType;
import csbase.logic.CommandInfo;

/**
 * Interface de uma visualizao de comandos, com suporte a mltiplas abas.
 */
interface CommandView {

  /**
   * Retorna o ttulo da janela da viso de comandos.
   * 
   * @return o ttulo.
   */
  public String getTitle();

  /**
   * Determina qual aba da viso deve ser selecionada, baseado no tipo da aba.
   * Mais de uma aba pode ter o mesmo tipo; nesse caso, a primeira aba do tipo 
   * mostrada.
   * 
   * @param tabType o tipo de aba a ser selecionada.
   * @throws ClientException em caso de erro na criao da viso da aba.
   */
  public abstract void selectTab(TabType tabType) throws ClientException;

  /**
   * Determina qual aba da viso deve ser selecionada, baseado no ttulo da aba.
   * No pode haver mais de uma aba com o mesmo ttulo.
   * 
   * @param title o ttulo da aba a ser selecionada.
   * @throws ClientException em caso de erro na criao da viso da aba.
   */
  public abstract void selectTab(String title) throws ClientException;

  /**
   * Retorna a aba selecionada no momento.
   * 
   * @return a aba.
   */
  public Tab getSelected();

  /**
   * Retorna o principal componente grfico da visuazalio.
   * 
   * @param owner Componente dono da viso (No aceita {@code null}).
   * 
   * @return o componente principal.
   * @throws ClientException em caso de erro na criao da viso.
   */
  public Component getMainComponent(DesktopComponentFrame owner)
    throws ClientException;

  /**
   * Atualiza as informaes do comando mostradas na viso.
   * 
   * @param type O tipo ({@link Type}) de atualizao sofrida pelo comando.
   * @param cmd As informaes atualizados do comando.
   */
  public void commandUpdated(Type type, CommandInfo cmd);

  /**
   * Obtm a barra de status da viso.
   * 
   * @return a barra de status.
   */
  public StatusBar getStatusBar();

  /**
   * Determina que aba padro da viso deve ser selecionada.
   * 
   * @throws ClientException em caso de erro na criao da viso da aba.
   */
  public void selectPreferredTab() throws ClientException;

  /**
   * Finaliza a viso antes da janela ser fechada.
   */
  public void close();

}
