package csbase.client.algorithms.tasks;

import java.awt.Window;

import tecgraf.javautils.core.lng.LNG;
import csbase.client.applications.flowapplication.graph.Graph;
import csbase.client.desktop.RemoteTask;
import csbase.logic.algorithms.flows.Flow;
import csbase.logic.algorithms.flows.configurator.FlowAlgorithmConfigurator;

/**
 * 
 */
public class CreateFlowConfiguratorTask extends
  RemoteTask<FlowAlgorithmConfigurator> {

  /**
   * A janela dona da task.
   */
  private final Window owner;

  /**
   * O fluxo.
   */
  private final Flow flow;

  /**
   * Construtor.
   * 
   * @param owner janela dona da task.
   * @param flow o fluxo.
   */
  public CreateFlowConfiguratorTask(Window owner, Flow flow) {
    this.owner = owner;
    this.flow = flow;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void performTask() throws Exception {
    Graph graph = new Graph(owner, flow);
    final FlowAlgorithmConfigurator configurator =
      new FlowAlgorithmConfigurator(graph.toFlow());
    setResult(configurator);
  }

  /**
   * Mtodo de convenincia para chamada automtica da task.
   * 
   * @param window janela dona da task.
   * @param flow o fluxo.
   * 
   * @return o resultado da validao.
   */
  static final public FlowAlgorithmConfigurator runTask(Window window, Flow flow) {
    CreateFlowConfiguratorTask task =
      new CreateFlowConfiguratorTask(window, flow);
    final String className = CreateFlowConfiguratorTask.class.getSimpleName();
    final String title = LNG.get(className + ".title");
    final String msg = LNG.get(className + ".msg");
    task.execute(window, title, msg);
    return task.getResult();
  }

}
