package csbase.client.applications.pdfviewer.actions;

import csbase.client.applications.Application;
import csbase.client.applications.ApplicationFrame;
import csbase.client.applications.ApplicationImages;
import csbase.client.applications.pdfviewer.PDFViewer;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil;
import csbase.client.util.filechooser.ClientProjectFileChooserUtil.OperationResult;
import csbase.logic.ClientFile;

/**
 * Ao que abre um arquivo da rea de projetos.
 * 
 * @author Tecgraf
 */
public class OpenProjectPdfFileAction extends AbstractOpenPdfFileAction {

  /**
   * Construtor padro.
   * 
   * @param application aplicao.
   */
  public OpenProjectPdfFileAction(PDFViewer application) {
    super(application, ApplicationImages.ICON_OPEN_16);
    setEnabled(false);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected ClientFile chooseClientFileOrNull() {
    Application application = getApplication();
    ApplicationFrame window = application.getApplicationFrame();
    String title = application.getName();

    OperationResult result =
      ClientProjectFileChooserUtil.browseSingleFileInOpenMode(window,
        getProjectFileExtensions(), title, true);

    if (result == null) {
      return null;
    }

    return result.getClientProjectFile();
  }
}
