/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util.csvpanel.table;

import csbase.client.util.csvpanel.columns.ColumnGenerator;
import csbase.client.util.csvpanel.table.CSVTableModel;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CSVTable
extends JTable {
    public CSVTable() {
        this((String[][])null);
    }

    public CSVTable(String[][] data) {
        this(data, false, 0);
    }

    public CSVTable(String[][] data, boolean editable, int numRowsAsHeader) {
        super(new CSVTableModel(data, editable, numRowsAsHeader));
        this.configureTableUI();
    }

    private void configureTableUI() {
        this.setFillsViewportHeight(true);
        this.setAutoResizeMode(0);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(1);
        this.setAutoCreateRowSorter(true);
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent arg0) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent arg0) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                CSVTable.this.adjustColumnPreferredWidths(e.getFromIndex(), e.getToIndex());
            }
        });
    }

    public void generateColum(ColumnGenerator<?> generator, int[] rows, int col) {
        for (int i = 0; i < rows.length; ++i) {
            int index = rows[i];
            Object valueAt = generator.getValueAt(i);
            String stringValue = null;
            if (valueAt != null) {
                stringValue = String.valueOf(valueAt);
            }
            this.setValueAt(stringValue, index, col);
        }
    }

    public void adjustColumnPreferredWidths(int from, int to) {
        TableColumnModel columns = this.getColumnModel();
        for (int col = from; col <= to; ++col) {
            Object headerValue;
            TableColumn column = columns.getColumn(col);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = new DefaultTableCellRenderer();
            }
            if ((headerValue = column.getHeaderValue()) == null) continue;
            Component headerComp = headerRenderer.getTableCellRendererComponent(this, headerValue, false, false, 0, col);
            int width = headerComp.getPreferredSize().width;
            column.setPreferredWidth(Math.max(width, 100));
        }
    }

    public void setData(String[][] data, boolean editable) {
        CSVTableModel tableModel = this.getModel();
        tableModel.setEditable(editable);
        tableModel.setData(data);
    }

    public boolean isEditable() {
        CSVTableModel tableModel = this.getModel();
        return tableModel.isEditable();
    }

    @Override
    public CSVTableModel getModel() {
        return (CSVTableModel)super.getModel();
    }
}

