/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.algorithms.parameters;

import csbase.client.algorithms.parameters.DefaultDoubleTextFieldModel;
import csbase.client.algorithms.parameters.NumberTextField;
import csbase.client.algorithms.parameters.NumberTextFieldModel;
import csbase.exception.ParseException;

public class DoubleTextField
extends NumberTextField<Double> {
    public DoubleTextField(Double errorValue) {
        this(new DefaultDoubleTextFieldModel(errorValue));
    }

    public DoubleTextField(NumberTextFieldModel<Double> model) {
        super(model);
    }

    @Override
    protected String format(Double number) {
        return number.toString();
    }

    @Override
    protected Double parse(String text) throws ParseException {
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            throw new ParseException("O texto informado n\u00e3o representa um n\u00famero real.\nTexto: ({0}).", new Object[]{text});
        }
    }
}

