/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.applications.algorithmsmanager.dialogs;

import csbase.client.applications.ApplicationImages;
import csbase.client.applications.algorithmsmanager.AlgorithmsManager;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmEditDataPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmStaticInfoPanel;
import csbase.client.applications.algorithmsmanager.dialogs.AlgorithmsAndCategoriesBindPanel;
import csbase.client.applications.algorithmsmanager.dialogs.CommonInfoEditPanel;
import csbase.client.applications.algorithmsmanager.models.AlgorithmListItem;
import csbase.client.applications.algorithmsmanager.models.DataInterface;
import csbase.client.remote.srvproxies.AlgorithmManagementProxy;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.Category;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JPanel;
import tecgraf.javautils.gui.GBC;

public class AlgorithmCategoryInfoPanel
extends CommonInfoEditPanel {
    private AlgorithmStaticInfoPanel algorithmHeaderPanel;
    private AlgorithmsAndCategoriesBindPanel bindPanel;
    private JPanel mainPanel;
    private boolean isEditing;

    public AlgorithmCategoryInfoPanel(AlgorithmEditDataPanel algoPane) {
        super(algoPane);
    }

    private AlgorithmEditDataPanel getAlgorithmEditDataPanel() {
        return (AlgorithmEditDataPanel)this.getEditPanel();
    }

    protected boolean saveInfo() {
        this.bindPanel.bindData();
        return true;
    }

    @Override
    public void initializeData() {
        if (this.getSelectedAlgorithm() == null) {
            return;
        }
        if (!this.isEditing) {
            this.algorithmHeaderPanel.setSelectedAlgorithm(this.getSelectedAlgorithm());
            this.bindPanel.initializeData(this.getSelectedAlgorithm(), this.getAvailableCategories(), this.getAlgorithmCategories());
            this.revalidate();
        }
        this.changeOperationsState(this.isEditing);
    }

    @Override
    protected JPanel buildMainInfoPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new GridBagLayout());
            this.algorithmHeaderPanel = new AlgorithmStaticInfoPanel((AlgorithmsManager)this.getApplication());
            this.bindPanel = this.getDataBindingPanel();
            this.mainPanel.add((Component)this.algorithmHeaderPanel, new GBC(0, 0).horizontal().west().insets(0, 0, 0, 0));
            this.mainPanel.add((Component)this.bindPanel, new GBC(0, 1).both().west().insets(0, 0, 0, 0));
        }
        return this.mainPanel;
    }

    @Override
    protected void apply() {
        this.isEditing = false;
        if (!this.saveInfo()) {
            return;
        }
    }

    @Override
    protected void cancel() {
        if (this.confirmCancelling()) {
            this.initializeData();
        }
    }

    private boolean confirmCancelling() {
        int confirm = ((AlgorithmsManager)this.getApplication()).showOptionDialog(this.getString("AlgorithmCategoryInfoPanel.msg.cancel.confirm"), new String[]{this.getString("AlgorithmCategoryInfoPanel.msg.cancel.confirm.yes"), this.getString("AlgorithmCategoryInfoPanel.msg.cancel.confirm.no")});
        if (confirm == 0) {
            this.isEditing = false;
            return true;
        }
        return false;
    }

    private AlgorithmsAndCategoriesBindPanel getDataBindingPanel() {
        if (this.bindPanel == null) {
            this.bindPanel = new AlgorithmsAndCategoriesBindPanel((AlgorithmsManager)this.getApplication(), this.getSelectedAlgorithm(), this.getAvailableCategories(), this.getAlgorithmCategories(), AlgorithmsAndCategoriesBindPanel.ItemType.CATEGORY_ITEM);
            this.bindPanel.addBindListener(wasModified -> {
                this.isEditing = wasModified;
                this.changeOperationsState(wasModified);
            });
        }
        return this.bindPanel;
    }

    private SortedSet<DataInterface> getAvailableCategories() {
        TreeSet<DataInterface> availableData = new TreeSet();
        availableData = this.getAllCategories();
        if (this.getSelectedAlgorithm() == null) {
            return availableData;
        }
        SortedSet<Category> categorySortedSet = this.getAlgorithmCategories(this.getSelectedAlgorithm().getItem());
        if (categorySortedSet == null) {
            return availableData;
        }
        Iterator availableIterator = availableData.iterator();
        while (availableIterator.hasNext()) {
            CategoryData item = (CategoryData)availableIterator.next();
            if (!categorySortedSet.contains(item.getCategory())) continue;
            availableIterator.remove();
        }
        return availableData;
    }

    private SortedSet<DataInterface> getAllCategories() {
        SortedSet<Category> allCategoryData = ((AlgorithmsManager)this.getApplication()).getAllCategories(true);
        return this.getCategoryDataInterfaceSet(allCategoryData);
    }

    private SortedSet<DataInterface> getCategoryDataInterfaceSet(SortedSet<Category> categories) {
        TreeSet<DataInterface> categoryDataSet = new TreeSet<DataInterface>();
        if (categories != null) {
            for (Category category : categories) {
                categoryDataSet.add(new CategoryData(category));
            }
        }
        return categoryDataSet;
    }

    private SortedSet<DataInterface> getAlgorithmCategories() {
        SortedSet<DataInterface> selectedData = new TreeSet<DataInterface>();
        if (this.getSelectedAlgorithm() != null) {
            SortedSet<Category> categories = this.getAlgorithmCategories(this.getSelectedAlgorithm().getItem());
            selectedData = this.getCategoryDataInterfaceSet(categories);
        }
        return selectedData;
    }

    private SortedSet<Category> getAlgorithmCategories(AlgorithmInfo algoInfo) {
        SortedSet<Category> categorySortedSet = AlgorithmManagementProxy.getAlgorithmCategories(((AlgorithmsManager)this.getApplication()).getApplicationFrame(), AlgorithmManagementProxy.AlgorithmOperation.ADMIN_ALGORITHM, this.getSelectedAlgorithm().getItem());
        return categorySortedSet;
    }

    @Override
    public void setDataChanged() {
        this.isEditing = false;
        this.changeOperationsState(this.isEditing);
    }

    private AlgorithmListItem getSelectedAlgorithm() {
        return this.getAlgorithmEditDataPanel().getSelectedAlgorithm();
    }

    @Override
    public boolean wasModified() {
        return this.bindPanel.wasModified();
    }

    @Override
    protected String getTitle() {
        return this.getString("AlgorithmCategoryInfoPanel.tab.category");
    }

    private class CategoryData
    implements DataInterface,
    Comparable<CategoryData> {
        private Category category;

        CategoryData(Category category) {
            this.category = category;
        }

        public Category getCategory() {
            return this.category;
        }

        @Override
        public String getName() {
            return this.category.getFullName();
        }

        @Override
        public String getId() {
            return this.category.getId();
        }

        @Override
        public Icon getIcon() {
            return ApplicationImages.ICON_FOLDER_16;
        }

        @Override
        public String getFullName() {
            return this.getName();
        }

        @Override
        public int compareTo(CategoryData categoryData) {
            return this.category.getId().compareToIgnoreCase(categoryData.getId());
        }
    }
}

