/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.project.action;

import csbase.client.applicationmanager.ApplicationManager;
import csbase.client.applicationmanager.ApplicationType;
import csbase.client.applications.fileexchanger.FileExchanger;
import csbase.client.desktop.DesktopComponentFrame;
import csbase.client.desktop.DesktopFrame;
import csbase.client.project.ProjectFileContainer;
import csbase.client.project.action.CommonProjectAction;
import csbase.client.util.StandardErrorDialogs;
import csbase.logic.ClientProjectFile;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import tecgraf.javautils.configurationmanager.Configuration;
import tecgraf.javautils.configurationmanager.ConfigurationManager;
import tecgraf.javautils.core.lng.LNG;

abstract class CommonExchangeAction
extends CommonProjectAction {
    private final String DEFAULT_APP_ID = "fileexchanger";
    private final String APP_ID_PROP_NAME = "file.exchanger.application.id";

    protected final FileExchanger getFileExchanger() {
        try {
            ConfigurationManager cnfMng = ConfigurationManager.getInstance();
            Configuration cnf = cnfMng.getConfiguration(this.getClass());
            String id = cnf.getOptionalProperty("file.exchanger.application.id", "fileexchanger");
            ApplicationManager appMng = ApplicationManager.getInstance();
            Vector<ApplicationType> runs = appMng.getRunningApplications(id);
            FileExchanger fe = runs != null && runs.size() > 0 ? (FileExchanger)runs.get(0) : (FileExchanger)appMng.runApplication(id);
            return fe;
        }
        catch (Exception e) {
            DesktopFrame desktopFrame = DesktopFrame.getInstance();
            DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
            StandardErrorDialogs.showErrorDialog(frame, this.getName(), "", e);
            return null;
        }
    }

    protected final synchronized boolean isFileExchangerRunning() {
        boolean result = false;
        try {
            ConfigurationManager cnfMng = ConfigurationManager.getInstance();
            Configuration cnf = cnfMng.getConfiguration(this.getClass());
            String id = cnf.getOptionalProperty("file.exchanger.application.id", "fileexchanger");
            ApplicationManager appMng = ApplicationManager.getInstance();
            Vector<ApplicationType> runs = appMng.getRunningApplications(id);
            if (runs != null && runs.size() > 0) {
                result = true;
            }
        }
        catch (Exception e) {
            DesktopFrame desktopFrame = DesktopFrame.getInstance();
            DesktopComponentFrame frame = desktopFrame.getDesktopFrame();
            StandardErrorDialogs.showErrorDialog(frame, this.getName(), "", e);
        }
        return result;
    }

    @Override
    public final String getName() {
        return this.getString("name");
    }

    protected final ClientProjectFile getSelectedRemoteFile() {
        ClientProjectFile file = this.getSelectedFile();
        return file;
    }

    protected final List<ClientProjectFile> getSelectedRemoteFiles() {
        ClientProjectFile[] files = this.getSelectedFiles();
        ArrayList<ClientProjectFile> list = new ArrayList<ClientProjectFile>();
        for (ClientProjectFile file : files) {
            list.add(file);
        }
        return list;
    }

    protected final String getString(String tag) {
        String className = this.getClass().getSimpleName();
        return LNG.get((String)(className + "." + tag));
    }

    public CommonExchangeAction(ProjectFileContainer container) {
        super(container);
    }
}

