/*
 * Decompiled with CFR 0.152.
 */
package csbase.client.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClientParameters {
    private static final String WHITESPACE_REGEX = "\\s";
    private static final String WHITESPACE = " ";
    private static final String PARAMETER_PREFIX = "--";
    private static final String OMIT_PREFIX = "omit:";
    private static final String OMITTED_DATA_PLACEHOLDER = "DATA_OMITTED";
    private List<String> parameterList = new ArrayList<String>();

    public ClientParameters add(String key, boolean value) {
        return this.add(key, value, PARAMETER_PREFIX);
    }

    public ClientParameters add(String key, boolean value, String prefix) {
        return this.add(key, Boolean.toString(value), prefix, false);
    }

    public ClientParameters add(String key, String value) {
        return this.add(key, value, PARAMETER_PREFIX, false);
    }

    public ClientParameters add(String key, String value, String prefix) {
        return this.add(key, value, prefix, false);
    }

    public ClientParameters add(String key, String value, boolean omit) {
        return this.add(key, value, PARAMETER_PREFIX, omit);
    }

    public ClientParameters add(String key, String value, String prefix, boolean omit) {
        String formattedParam = prefix + key;
        if (!formattedParam.isEmpty()) {
            formattedParam = formattedParam + WHITESPACE;
        }
        if (omit) {
            formattedParam = formattedParam + OMIT_PREFIX;
        }
        this.parameterList.add(formattedParam + value);
        return this;
    }

    public List<String> get() {
        return new ArrayList<String>(this.parameterList);
    }

    public static Map<String, String> process(String[] arguments) throws IllegalArgumentException {
        return ClientParameters.process(arguments, false);
    }

    public static Map<String, String> process(String[] arguments, boolean printOutput) throws IllegalArgumentException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String arg : arguments) {
            String[] parameter = arg.trim().split(WHITESPACE_REGEX);
            if (parameter.length != 2) {
                throw new IllegalArgumentException(MessageFormat.format("O argumento {0} est\u00e1 inv\u00e1lido.", arg));
            }
            String key = parameter[0].substring(2);
            String value = parameter[1];
            if (printOutput) {
                if (value.startsWith(OMIT_PREFIX)) {
                    value = value.substring(OMIT_PREFIX.length());
                    System.out.println(key + "   " + OMITTED_DATA_PLACEHOLDER);
                } else {
                    System.out.println(key + "   " + value);
                }
            }
            parameterMap.put(key, value);
        }
        return parameterMap;
    }
}

