/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.IPathFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileInfo
implements Serializable,
Comparable<FileInfo> {
    private static final FilenameFilter NAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return FileInfo.isNameValid(name);
        }
    };
    private FileInfo parent;
    private final String name;
    private final List<FileInfo> children;
    private final List<FileInfo> unmodifiableChildren;
    private final boolean isDirectory;

    public FileInfo(String[] path, String name, boolean isDirectory) {
        this(name, isDirectory);
        FileInfo child = this;
        int inx = path.length - 1;
        while (inx >= 0) {
            String parentName = path[inx];
            FileInfo parent = new FileInfo(parentName, true);
            child.setParent(parent);
            child = parent;
            --inx;
        }
    }

    public FileInfo(File file) {
        this(file.getName(), file.isDirectory());
        List<FileInfo> executables = FileInfo.createFilesInfo(file);
        for (FileInfo executable : executables) {
            this.addChild(executable);
        }
        Collections.sort(this.children);
    }

    public FileInfo(String name, boolean isDirectory) {
        if (!FileInfo.isNameValid(name)) {
            throw new IllegalArgumentException("Invalid name " + name);
        }
        this.name = name.trim();
        this.isDirectory = isDirectory;
        this.parent = null;
        this.children = isDirectory ? new ArrayList<FileInfo>() : Collections.emptyList();
        this.unmodifiableChildren = Collections.unmodifiableList(this.children);
    }

    public static List<FileInfo> createFilesInfo(File dir) {
        File[] childrenFile;
        if (dir.isDirectory() && (childrenFile = dir.listFiles(NAME_FILTER)).length > 0) {
            ArrayList<FileInfo> executables = new ArrayList<FileInfo>();
            File[] fileArray = childrenFile;
            int n = childrenFile.length;
            int n2 = 0;
            while (n2 < n) {
                File childFile = fileArray[n2];
                FileInfo executable = new FileInfo(childFile);
                executables.add(executable);
                ++n2;
            }
            return executables;
        }
        return Collections.emptyList();
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.trim().equalsIgnoreCase(".svn");
    }

    public String getName() {
        return this.name;
    }

    public FileInfo getParent() {
        return this.parent;
    }

    public List<FileInfo> getChildren() {
        return this.unmodifiableChildren;
    }

    public boolean addChild(FileInfo child) {
        if (this.isDirectory && this.children.add(child)) {
            child.setParent(this);
            return true;
        }
        return false;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public String getPath() {
        return IPathFactory.DEFAULT.getPath(this);
    }

    public String[] getPathAsArray() {
        List<String> path = this._getPath();
        return path.toArray(new String[path.size()]);
    }

    private List<String> _getPath() {
        List<Object> path = this.getParent() == null ? new ArrayList() : this.getParent()._getPath();
        path.add(this.getName());
        return path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isDirectory ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileInfo other = (FileInfo)obj;
        if (this.isDirectory != other.isDirectory) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    @Override
    public int compareTo(FileInfo o) {
        if (this.isDirectory() && !o.isDirectory()) {
            return -1;
        }
        if (!this.isDirectory() && o.isDirectory()) {
            return 1;
        }
        return Collator.getInstance().compare(this.getName(), o.getName());
    }

    public String toString() {
        return this.getName();
    }

    private void setParent(FileInfo parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
    }
}

