/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CapacityType;
import csbase.logic.MonitoringSet;
import csbase.logic.SGAInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;

public class SGASet
implements MonitoringSet,
Comparable<SGASet> {
    private SGAInfo[] info = null;
    private String name = null;
    private String platform = null;
    private boolean isCluster;
    private boolean enabled;
    private boolean alive;
    private boolean hasDiskAccess;
    private String jobsInfo;
    private boolean CSFSEnabled;
    private boolean allowNodeSel;

    private String updatePlatformId() {
        StringBuilder allPlats = new StringBuilder();
        if (this.info != null) {
            Vector<String> plats = new Vector<String>();
            int i = 0;
            while (i < this.info.length) {
                String platformId = this.info[i].getPlatformId();
                if (!plats.contains(platformId)) {
                    plats.add(platformId);
                }
                ++i;
            }
            Enumeration e = plats.elements();
            while (e.hasMoreElements()) {
                allPlats.append((String)e.nextElement());
                if (!e.hasMoreElements()) continue;
                allPlats.append('/');
            }
        }
        return allPlats.toString();
    }

    @Override
    public int compareTo(SGASet object) {
        return this.toString().compareToIgnoreCase(object.toString());
    }

    public SGAInfo getHost(String hostName) {
        int i = this.info.length - 1;
        while (i > 0 && !this.info[i].getHostName().equals(hostName)) {
            --i;
        }
        return this.info[i];
    }

    public SGAInfo getInfo(int index) {
        return this.info[index];
    }

    public SGAInfo[] getAllInfo() {
        return this.info;
    }

    public String[] getAllNames() {
        Object[] names = new String[this.info.length];
        int i = 0;
        while (i < this.info.length) {
            names[i] = this.info[i].getHostName();
            ++i;
        }
        Arrays.sort(names);
        return names;
    }

    public long getCapacity(CapacityType capacityType) {
        return this.info[0].getCapacity(capacityType);
    }

    public int getNumNodes() {
        return this.info.length;
    }

    public int getNumProcessors() {
        return this.info[0].getNumProcessors();
    }

    public int getRAMMemoryInfoMb() {
        return this.info[0].getRAMMemoryInfoMb();
    }

    public int getSwapMemoryInfoMb() {
        return this.info[0].getSwapMemoryInfoMb();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlatformSupported(Collection<String> platformId) {
        int i = 0;
        while (i < this.info.length) {
            String nodePlatform = this.info[i].getPlatformId();
            if (platformId.contains(nodePlatform)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getPlatformId() {
        return this.platform;
    }

    public String getHostOfPlatform(Collection<String> plats) {
        int i = 0;
        while (i < this.info.length) {
            String platformId = this.info[i].getPlatformId();
            if (plats.contains(platformId)) {
                return this.info[i].getHostName();
            }
            ++i;
        }
        return null;
    }

    public double getCPULoad1() {
        return this.info[0].getCPULoad1();
    }

    public double getCPULoad5() {
        return this.info[0].getCPULoad5();
    }

    public double getCPULoad15() {
        return this.info[0].getCPULoad15();
    }

    public double getRAMFreeMemory() {
        return this.info[0].getRAMFreeMemory();
    }

    public double getRAMFreeMemoryMb() {
        return this.info[0].getRAMFreeMemoryMb();
    }

    public double getSwapFreeMemory() {
        return this.info[0].getSwapFreeMemory();
    }

    public boolean hasRequirement(String requirement) {
        SGAInfo[] sGAInfoArray = this.info;
        int n = this.info.length;
        int n2 = 0;
        while (n2 < n) {
            SGAInfo node = sGAInfoArray[n2];
            if (!node.hasRequirement(requirement)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean hasRequirements(Set<String> requirements) {
        for (String requirement : requirements) {
            SGAInfo[] sGAInfoArray = this.info;
            int n = this.info.length;
            int n2 = 0;
            while (n2 < n) {
                SGAInfo node = sGAInfoArray[n2];
                if (!node.hasRequirement(requirement)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public Status getStatus() {
        if (this.getAlive()) {
            if (this.getEnabled()) {
                if (this.hasDiskAccess()) {
                    return Status.AVAILABLE;
                }
                return Status.DISKLESS;
            }
            return Status.RESERVED;
        }
        return Status.INACCESSIBLE;
    }

    public boolean mayExecuteCommand() {
        return this.getAlive() && this.getEnabled() && this.hasDiskAccess();
    }

    public boolean getAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        if (alive) {
            return;
        }
        int i = 0;
        while (i < this.info.length) {
            this.info[i].setAlive(false);
            ++i;
        }
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public boolean hasDiskAccess() {
        return this.hasDiskAccess;
    }

    public String getJobsInfo() {
        return this.jobsInfo;
    }

    public boolean isCSFSEnabled() {
        return this.CSFSEnabled;
    }

    public boolean allowNodeSelection() {
        return this.allowNodeSel;
    }

    @Override
    public boolean equals(MonitoringSet o) {
        if (!(o instanceof SGASet)) {
            return false;
        }
        SGASet other = (SGASet)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getAlive() != other.getAlive() || this.getEnabled() != other.getEnabled()) {
            return false;
        }
        if (this.hasDiskAccess() != other.hasDiskAccess()) {
            return false;
        }
        if (this.getCPULoad1() != other.getCPULoad1()) {
            return false;
        }
        if (this.getRAMMemoryInfoMb() != other.getRAMMemoryInfoMb()) {
            return false;
        }
        if (this.getSwapMemoryInfoMb() != other.getSwapMemoryInfoMb()) {
            return false;
        }
        return this.getPlatformId().equals(other.getPlatformId());
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(Boolean.toString(this.getAlive()));
        buffer.append(Boolean.toString(this.getEnabled()));
        buffer.append(Double.toString(this.getCPULoad1()));
        buffer.append(Integer.toString(this.getRAMMemoryInfoMb()));
        buffer.append(Integer.toString(this.getSwapMemoryInfoMb()));
        buffer.append(this.getPlatformId());
        return buffer.toString().hashCode();
    }

    public SGAInfo getMainInfo() {
        return this.info[0];
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public SGASet(SGAInfo[] info, String name, boolean enabled, boolean alive, boolean hasDiskAccess, String jobsInfo, boolean CSFSEnabled) {
        this(info, name, enabled, alive, hasDiskAccess, jobsInfo, CSFSEnabled, true);
    }

    public SGASet(SGAInfo[] info, String name, boolean enabled, boolean alive, boolean hasDiskAccess, String jobsInfo, boolean CSFSEnabled, boolean allowNodeSel) {
        this.info = info;
        this.name = name;
        this.isCluster = info.length > 1;
        this.allowNodeSel = this.isCluster ? allowNodeSel : true;
        this.enabled = enabled;
        this.setAlive(alive);
        this.hasDiskAccess = hasDiskAccess;
        this.platform = this.updatePlatformId();
        this.jobsInfo = jobsInfo;
        this.CSFSEnabled = CSFSEnabled;
    }

    public static enum Status {
        AVAILABLE,
        DISKLESS,
        RESERVED,
        INACCESSIBLE;


        public static int getIndex(Enum<Status> constantToFind) {
            int i = 0;
            while (i < Status.values().length) {
                if (Status.values()[i] == constantToFind) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

