/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.MDigest;
import java.io.Serializable;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;

public class SecureKey
implements Serializable {
    private final int KEY_SIZE = 10;
    private byte[] value = new byte[10];
    private int hashCode;
    private static final String PRNG_ALGORITHM = "SHA1PRNG";

    public boolean equals(Object key) {
        if (key instanceof SecureKey) {
            SecureKey anotherKey = (SecureKey)key;
            return Arrays.equals(this.value, anotherKey.value);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int hashCode = 1;
        int i = 0;
        while (i < 10) {
            hashCode = 31 * hashCode + Byte.valueOf(this.value[i]).hashCode();
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < 10) {
            str.append(this.value[i]);
            ++i;
        }
        str.append('\n');
        return str.toString();
    }

    public String digest() throws DigestException {
        return MDigest.getDigest(this.value);
    }

    public SecureKey() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance(PRNG_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            secureRandom = new SecureRandom();
        }
        secureRandom.nextBytes(this.value);
        this.hashCode = this.generateHashCode();
    }
}

