/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.Getter;
import csbase.logic.User;
import csbase.logic.UserGroup;
import csbase.util.StringUtils;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Date;

public class UserOutline
implements Serializable {
    private Object userId;
    private String login;
    private String[] emails;
    private String name;
    private String userGroupName;
    private Date creationDate;

    public Object getId() {
        return this.userId;
    }

    public String getLogin() {
        return this.login;
    }

    public String getName() {
        return this.name;
    }

    public String[] getEmails() {
        return this.emails;
    }

    public String getUserGroup() {
        return this.userGroupName;
    }

    public void setUserGroupName(String userGroupName) {
        this.userGroupName = userGroupName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String toString() {
        String userGroupStr = this.userGroupName.trim().equals("") ? "" : " - " + this.userGroupName;
        String naStr = this.getName().trim().equals("") ? "?" : this.getName();
        return String.valueOf(naStr) + " (" + this.login + ")" + userGroupStr;
    }

    public static Comparator<UserOutline> getNameComparator() {
        Comparator<UserOutline> nameComparator = new Comparator<UserOutline>(){

            @Override
            public int compare(UserOutline r1, UserOutline r2) {
                String n1 = r1.getName().trim().equals("") ? "???" : r1.getName();
                String n2 = r2.getName().trim().equals("") ? "???" : r2.getName();
                return StringUtils.compare((String)n1, (String)n2);
            }
        };
        return nameComparator;
    }

    public static Comparator<UserOutline> getLoginComparator() {
        final Collator collator = Collator.getInstance();
        collator.setStrength(2);
        Comparator<UserOutline> loginComparator = new Comparator<UserOutline>(){

            @Override
            public int compare(UserOutline o1, UserOutline o2) {
                return collator.compare(o1.getLogin(), o2.getLogin());
            }
        };
        return loginComparator;
    }

    public static Comparator<UserOutline> getUserGroupComparator() {
        final Collator collator = Collator.getInstance();
        collator.setStrength(2);
        Comparator<UserOutline> userGroupComparator = new Comparator<UserOutline>(){

            @Override
            public int compare(UserOutline o1, UserOutline o2) {
                return collator.compare(o1.getUserGroup(), o2.getUserGroup());
            }
        };
        return userGroupComparator;
    }

    public static Getter getLoginGetter() {
        Getter loginGetter = new Getter(){

            @Override
            public Object get(Object o) {
                UserOutline userOutline = (UserOutline)o;
                return userOutline.getLogin();
            }
        };
        return loginGetter;
    }

    public static Getter getUserGroupGetter() {
        Getter userGroupGetter = new Getter(){

            @Override
            public Object get(Object o) {
                UserOutline userOutline = (UserOutline)o;
                return userOutline.getUserGroup();
            }
        };
        return userGroupGetter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserOutline)) {
            return false;
        }
        UserOutline outline = (UserOutline)obj;
        return outline.getId().equals(this.userId);
    }

    public int hashCode() {
        return this.userId.hashCode();
    }

    public UserOutline(User user) throws Exception {
        this.userId = user.getId();
        this.login = user.getLogin();
        UserGroup userGroup = UserGroup.getUserGroupFromUser(user);
        this.emails = user.getEmails();
        this.name = user.getName();
        this.userGroupName = userGroup == null ? "" : userGroup.getName();
        this.creationDate = user.getCreationDate();
    }

    public UserOutline(Object userId, String login, String name, String userGroupName, String[] emails) {
        this.userId = userId;
        this.login = login;
        this.name = name;
        this.userGroupName = userGroupName;
        this.emails = emails;
    }
}

