/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.File;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utilities {
    private static final String DEFAULT_DATE_FORMAT = "dd/MM/yyyy - HH:mm:ss";

    public static String makeRelativePath(String[] pathArray) {
        if (pathArray == null) {
            return "";
        }
        StringBuilder path = new StringBuilder();
        int i = 0;
        while (i < pathArray.length - 1) {
            path.append(pathArray[i]);
            path.append(File.separatorChar);
            ++i;
        }
        if (pathArray.length > 0) {
            path.append(pathArray[pathArray.length - 1]);
        }
        return path.toString();
    }

    public static String makePath(String[] pathArray) {
        if (pathArray == null) {
            return "";
        }
        return String.valueOf(File.separator) + Utilities.makeRelativePath(pathArray);
    }

    public static String[] splitProjectPath(String pathText) {
        return Utilities.splitPath("/", pathText);
    }

    private static String[] splitPath(String sepPattern, String pathText) {
        sepPattern = sepPattern.replaceAll("\\\\", "\\\\\\\\");
        String[] path = pathText.split(sepPattern);
        int i = 0;
        while (i < path.length && path[i].equals("")) {
            ++i;
        }
        if (i > 0) {
            String[] newPath = new String[path.length - i];
            System.arraycopy(path, i, newPath, 0, newPath.length);
            path = newPath;
        }
        return path;
    }

    public static String getFormattedDate(Date date) {
        return Utilities.getFormattedDate(date, DEFAULT_DATE_FORMAT);
    }

    public static String getFormattedDate(long timeInMillis) {
        Date date = new Date(timeInMillis);
        return Utilities.getFormattedDate(date);
    }

    public static Date parseDate(String formattedDate) throws ParseException {
        if (formattedDate == null) {
            throw new IllegalArgumentException("formattedDate == null");
        }
        String format = DEFAULT_DATE_FORMAT;
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.parse(formattedDate);
    }

    public static String getFormattedDate(long timeInMillis, String format) {
        Date date = new Date(timeInMillis);
        return Utilities.getFormattedDate(date, format);
    }

    public static String getFormattedDate(Date date, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Object[] removeItemFromArray(Object[] array, int index) {
        if (array == null || array.length == 0) {
            return null;
        }
        if (index < 0 || index > array.length - 1) {
            return null;
        }
        Class<?> arrayClass = array[0].getClass();
        Object[] newArray = (Object[])Array.newInstance(arrayClass, array.length - 1);
        System.arraycopy(array, 0, newArray, 0, index);
        if (index < array.length - 1) {
            System.arraycopy(array, index + 1, newArray, index, array.length - 1 - index);
        }
        return newArray;
    }
}

