/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.ProjectFileType;
import csbase.logic.algorithms.CommandLineBuilder;
import csbase.logic.algorithms.CommandLineContext;
import java.util.List;

public class CommandScript {
    private static final String SCRIPT_FILE_TYPE = "SCRIPT";
    private static final String DEFAULT_SCRIPT_FILE_NAME = "script";
    private String scriptContent;
    private String fileName;
    private String persistencePath;

    public CommandScript(CommandLineContext context, String scriptContent) {
        this(context, scriptContent, null);
    }

    public CommandScript(CommandLineContext context, String scriptContent, String fileName) {
        this.setScriptContent(context, scriptContent);
        this.fileName = fileName == null ? CommandScript.makeFileName(null) : fileName;
        this.persistencePath = String.valueOf(context.getPersistenceDirectory()) + context.getFileSeparator();
    }

    protected void setScriptContent(CommandLineContext context, String scriptContent) {
        CommandLineBuilder content = new CommandLineBuilder(true);
        content.appendScriptHeader(context);
        content.append(scriptContent);
        this.scriptContent = content.toString();
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public String getFileName() {
        return this.fileName;
    }

    protected String getPersistencePath() {
        return this.persistencePath;
    }

    public String makeCommandLine() {
        return "/bin/ksh " + this.persistencePath + this.fileName;
    }

    public static String makeFileName(String suffix) {
        String extension;
        List<String> scriptFileExtensions;
        ProjectFileType fileType;
        StringBuilder name = new StringBuilder();
        name.append(DEFAULT_SCRIPT_FILE_NAME);
        if (suffix != null) {
            name.append(suffix);
        }
        if ((fileType = ProjectFileType.getFileType(SCRIPT_FILE_TYPE)) != null && !(scriptFileExtensions = fileType.getExtensions()).isEmpty() && !(extension = scriptFileExtensions.get(0).trim()).isEmpty()) {
            name.append(".");
            name.append(extension);
        }
        return name.toString();
    }
}

