/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.StringToEnumConverter;

public enum ExecutionLocation {
    BINARY_DIR,
    PERSISTENCY_DIR,
    SANDBOX;


    public static class ExecutionLocationConverter
    implements StringToEnumConverter<ExecutionLocation> {
        public String[] getPossibleMatches(ExecutionLocation value) {
            switch (value) {
                case BINARY_DIR: {
                    return new String[]{"BIN", "BIN_DIR", "BINARY_DIR"};
                }
                case PERSISTENCY_DIR: {
                    return new String[]{"CMD", "CMD_DIR", "PERSISTENCY_DIR"};
                }
                case SANDBOX: {
                    return new String[]{"SANDBOX", "SANDBOX_DIR"};
                }
            }
            return new String[0];
        }

        @Override
        public ExecutionLocation valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                ExecutionLocation[] executionLocationArray = ExecutionLocation.values();
                int n = executionLocationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] possibleMatches;
                    ExecutionLocation location = executionLocationArray[n2];
                    String[] stringArray = possibleMatches = this.getPossibleMatches(location);
                    int n3 = possibleMatches.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String possibleMatch = stringArray[n4];
                        if (possibleMatch.toUpperCase().equals(upperCaseString)) {
                            return location;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            throw new ParseException("A string " + string + " n\u00e3o p\u00f4de ser mapeada para um item de enumera\u00e7\u00e3o do tipo " + ExecutionLocation.class.getName());
        }
    }
}

