/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import java.util.List;

public abstract class ListExpressionFunction
extends ExpressionFunction {
    public ListExpressionFunction(String name, Class<?> ... parameterTypes) {
        super(name, ListExpressionFunction.createParameterTypes(parameterTypes));
    }

    protected abstract Object doOperation(List<?> var1, Object ... var2) throws ExpressionFunctionExecutionException;

    @Override
    protected final Object doOperation(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        if (configurator == null) {
            throw new IllegalArgumentException("O par\u00e2metro configurator est\u00e1 nulo.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameters est\u00e1 nulo.");
        }
        if (parameters.length == 0) {
            throw new ExpressionFunctionExecutionException("Esta fun\u00e7\u00e3o trabalha sobre listas.\nO primeiro par\u00e2metro tem que ser uma lista, por\u00e9m n\u00e3o foram informados valores.\nPrimeiro forne\u00e7a o nome da lista a ser utilizada.\nFun\u00e7\u00e3o: {0}.", this);
        }
        if (!(parameters[0] instanceof String)) {
            throw new ExpressionFunctionExecutionException("Esta fun\u00e7\u00e3o trabalha sobre listas.\nO primeiro valor tem que ser uma lista, por\u00e9m foi informado um valor que n\u00e3o \u00e9 um nome de lista.\nPrimeiro forne\u00e7a o nome da lista a ser utilizada.\nFun\u00e7\u00e3o: {0}.\nValor: {1}.", this, parameters[0]);
        }
        String parameterName = (String)parameters[0];
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ExpressionFunctionExecutionException("A lista {0} n\u00e3o foi encontrada no configurador {1}.\nFun\u00e7\u00e3o: {2}.", parameterName, configurator, this);
        }
        if (!(parameter instanceof ListParameter)) {
            throw new ExpressionFunctionExecutionException("O par\u00e2metro {0} do configurador {1} n\u00e3o \u00e9 uma lista.\nFun\u00e7\u00e3o: {2}.", parameterName, configurator, this);
        }
        ListParameter listParameter = (ListParameter)parameter;
        Object[] newParameters = new Object[parameters.length - 1];
        int i = 0;
        while (i < newParameters.length) {
            newParameters[i] = parameters[i + 1];
            ++i;
        }
        List values = (List)listParameter.getValue();
        return this.doOperation(values, newParameters);
    }

    private static Class<?>[] createParameterTypes(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException("O par\u00e2metro parameterTypes est\u00e1 nulo.");
        }
        Class[] newParameterTypes = new Class[parameterTypes.length + 1];
        newParameterTypes[0] = String.class;
        int i = 1;
        while (i < newParameterTypes.length) {
            newParameterTypes[i] = parameterTypes[i - 1];
            ++i;
        }
        return newParameterTypes;
    }
}

